/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import oreregistry.api.IUnificationHandler;
import oreregistry.api.OreRegistryState;
import oreregistry.api.registry.IResource;
import oreregistry.api.registry.IResourceRegistry;
import oreregistry.util.Resource;

public final class ResourceRegistry
implements IResourceRegistry {
    private final Map<String, IResource> resources = new HashMap<String, IResource>();
    private final Multimap<String, IUnificationHandler> unificationHandlers = HashMultimap.create();
    private OreRegistryState state = OreRegistryState.ACTIVE;

    @Override
    public IResource registerResource(String resourceType) {
        Preconditions.checkNotNull((Object)resourceType, (Object)"resourceType must not be null");
        if (this.hasResource(resourceType)) {
            return this.getResource(resourceType);
        }
        Resource resource = new Resource(resourceType);
        this.addResource(resource);
        return resource;
    }

    @Override
    public Map<String, IResource> getRegisteredResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    @Override
    public void registerUnificationHandler(String resourceType, IUnificationHandler unificationHandler) {
        this.unificationHandlers.put((Object)resourceType, (Object)unificationHandler);
    }

    @Override
    public Collection<IUnificationHandler> getUnificationHandlers(String resourceType) {
        return this.unificationHandlers.get((Object)resourceType);
    }

    @Override
    public OreRegistryState getState() {
        return this.state;
    }

    @Nullable
    public IResource getResource(String type) {
        return this.resources.get(type);
    }

    public boolean hasResource(String type) {
        return this.getResource(type) != null;
    }

    public void addResource(IResource resource) {
        if (this.state != OreRegistryState.ACTIVE) {
            return;
        }
        String type = resource.getType();
        if (!this.resources.containsKey(type)) {
            this.resources.put(type, resource);
        }
    }

    public void setState(OreRegistryState state) {
        this.state = state;
    }
}

