/*
 * Decompiled with CFR 0.152.
 */
package oreregistry;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import oreregistry.EventHandler;
import oreregistry.api.OreRegistryApi;
import oreregistry.api.registry.IResource;
import oreregistry.api.registry.IResourceRegistry;
import oreregistry.config.Config;
import oreregistry.network.PacketHandler;
import oreregistry.util.ResourceInfo;
import oreregistry.util.ResourceRegistry;

@Mod(modid="oreregistry", name="Ore Registry", version="1.0.0.7", acceptedMinecraftVersions="[1.11]")
public class OreRegistry {
    @Nullable
    @Mod.Instance(value="oreregistry")
    public static OreRegistry instance;
    public static final ResourceRegistry registry;
    public static final ResourceInfo helper;
    public static final List<ItemStack> unusedItems;
    @Nullable
    public static File configFile;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        OreRegistry.registerVanilla(OreRegistryApi.registry);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        new PacketHandler();
        configFile = event.getSuggestedConfigurationFile();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        Config.load(event.getSide());
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
    }

    private static void registerVanilla(IResourceRegistry resourceRegistry) {
        IResource iron = resourceRegistry.registerResource("iron");
        iron.registerProduct("ingot", new ItemStack(Items.field_151042_j));
        iron.registerProduct("nugget", new ItemStack(Items.field_191525_da));
        iron.registerProduct("block", new ItemStack(Blocks.field_150339_S));
        iron.registerProduct("ore", new ItemStack(Blocks.field_150366_p));
        iron.registerProduct("ore", new ItemStack(Blocks.field_150336_V));
        IResource gold = resourceRegistry.registerResource("gold");
        gold.registerProduct("ingot", new ItemStack(Items.field_151043_k));
        gold.registerProduct("nugget", new ItemStack(Items.field_151074_bl));
        gold.registerProduct("block", new ItemStack(Blocks.field_150340_R));
        gold.registerProduct("ore", new ItemStack(Blocks.field_150352_o));
        IResource emerald = resourceRegistry.registerResource("emerald");
        emerald.registerProduct("gem", new ItemStack(Items.field_151166_bC));
        emerald.registerProduct("block", new ItemStack(Blocks.field_150475_bE));
        emerald.registerProduct("ore", new ItemStack(Blocks.field_150412_bA));
        IResource diamond = resourceRegistry.registerResource("diamond");
        diamond.registerProduct("gem", new ItemStack(Items.field_151045_i));
        diamond.registerProduct("block", new ItemStack(Blocks.field_150484_ah));
        diamond.registerProduct("ore", new ItemStack(Blocks.field_150482_ag));
        IResource lapis = resourceRegistry.registerResource("lapis");
        lapis.registerProduct("gem", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
        lapis.registerProduct("block", new ItemStack(Blocks.field_150368_y));
        lapis.registerProduct("ore", new ItemStack(Blocks.field_150369_x));
        IResource redstone = resourceRegistry.registerResource("redstone");
        redstone.registerProduct("dust", new ItemStack(Items.field_151137_ax));
        redstone.registerProduct("block", new ItemStack(Blocks.field_150451_bX));
        redstone.registerProduct("ore", new ItemStack(Blocks.field_150450_ax));
        IResource quartz = resourceRegistry.registerResource("quartz");
        quartz.registerProduct("gem", new ItemStack(Items.field_151128_bU));
        quartz.registerProduct("block", new ItemStack(Blocks.field_150371_ca));
        quartz.registerProduct("ore", new ItemStack(Blocks.field_150449_bY));
        IResource coal = resourceRegistry.registerResource("coal");
        coal.registerProduct("gem", new ItemStack(Items.field_151044_h));
        coal.registerProduct("block", new ItemStack(Blocks.field_150402_ci));
        coal.registerProduct("ore", new ItemStack(Blocks.field_150365_q));
    }

    public File getConfigFile() {
        return configFile;
    }

    static {
        unusedItems = new ArrayList<ItemStack>();
        registry = new ResourceRegistry();
        OreRegistryApi.registry = registry;
        helper = new ResourceInfo();
        OreRegistryApi.info = helper;
    }
}

