/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import oreregistry.api.info.IProductInfo;
import oreregistry.api.info.IResourceInfo;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;
import oreregistry.util.ProductInfo;

public class ResourceInfo
implements IResourceInfo {
    private final Map<Item, List<IResource>> resourceItems = new IdentityHashMap<Item, List<IResource>>();

    @Override
    @Nullable
    public IProductInfo getProductInfo(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack must not be null");
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"itemStack must not be empty");
        Item item = itemStack.func_77973_b();
        List<IResource> resources = this.resourceItems.get(item);
        if (resources != null) {
            for (IResource resource : resources) {
                Map<String, IProduct> registeredProducts = resource.getRegisteredProducts();
                for (Map.Entry<String, IProduct> entry : registeredProducts.entrySet()) {
                    ItemStack product = entry.getValue().getChosenProduct();
                    if (!ItemStack.func_179545_c((ItemStack)product, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)product)) continue;
                    String productType = entry.getKey();
                    return new ProductInfo(resource.getType(), productType);
                }
            }
        }
        return null;
    }

    public void registerResourceItem(ItemStack itemStack, IResource resource) {
        Item item = itemStack.func_77973_b();
        List resources = this.resourceItems.computeIfAbsent(item, k -> new ArrayList());
        resources.add(resource);
    }
}

