/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import oreregistry.OreRegistry;
import oreregistry.api.OreRegistryState;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;
import oreregistry.util.Product;

public class Resource
implements IResource {
    private final String type;
    private final Map<String, Product> products = new HashMap<String, Product>();

    public Resource(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IProduct registerProduct(String productType, ItemStack productVariant) {
        Preconditions.checkNotNull((Object)productType, (Object)"Product Type must not be null");
        Preconditions.checkNotNull((Object)productVariant.func_190926_b(), (Object)"Product Variant must not be empty");
        OreRegistryState state = OreRegistry.registry.getState();
        if (state != OreRegistryState.ACTIVE) {
            throw new UnsupportedOperationException("Products must not be registered in other states than the ACTIVE state, current state is: " + (Object)((Object)state));
        }
        Product product = this.products.computeIfAbsent(productType, k -> new Product(this, (String)k));
        product.addVariant(productVariant);
        return product;
    }

    @Override
    public boolean hasProduct(String productType) {
        return this.getProduct(productType) != null;
    }

    @Override
    @Nullable
    public IProduct getProduct(String productType) {
        Preconditions.checkNotNull((Object)productType, (Object)"Product Type must not be null");
        return this.products.get(productType);
    }

    @Override
    public Map<String, IProduct> getRegisteredProducts() {
        return Collections.unmodifiableMap(this.products);
    }
}

