/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oreregistry.api.registry.IResource;
import oreregistry.api.registry.IResourceRegistry;
import oreregistry.util.Resource;

public final class ResourceRegistry
implements IResourceRegistry {
    protected final Map<String, IResource> resources = new HashMap<String, IResource>();

    @Override
    public IResource registerResource(String resourceType) {
        Preconditions.checkNotNull((Object)resourceType, (Object)"resourceType must not be null");
        if (this.resources.containsKey(resourceType)) {
            return this.resources.get(resourceType);
        }
        Resource resource = new Resource(resourceType);
        this.resources.put(resource.getType(), resource);
        return resource;
    }

    @Override
    public Map<String, IResource> getRegisteredResources() {
        return Collections.unmodifiableMap(this.resources);
    }
}

