/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import oreregistry.OreRegistry;
import oreregistry.api.registry.IResource;

public class Resource
implements IResource {
    private final String type;
    private final Map<String, ItemStack> products = new HashMap<String, ItemStack>();

    public Resource(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ItemStack registerProduct(String productType, ItemStack product) {
        Preconditions.checkNotNull((Object)productType, (Object)"Product Type must not be null");
        Preconditions.checkNotNull((Object)product, (Object)"Product must not be null");
        Preconditions.checkArgument((!product.func_190926_b() ? 1 : 0) != 0, (Object)"Product must not be empty");
        ItemStack chosenProduct = this.products.get(productType);
        if (chosenProduct == null) {
            chosenProduct = product.func_77946_l();
            chosenProduct.func_190920_e(1);
            this.products.put(productType, chosenProduct);
            OreRegistry.helper.registerResourceItem(chosenProduct, this);
        } else {
            OreRegistry.unusedItems.add(product);
        }
        return chosenProduct.func_77946_l();
    }

    @Override
    public boolean hasProduct(String productType) {
        Preconditions.checkNotNull((Object)productType, (Object)"Product Type must not be null");
        return this.products.get(productType) != null;
    }

    @Override
    public Map<String, ItemStack> getRegisteredProducts() {
        return Collections.unmodifiableMap(this.products);
    }
}

