package oreregistry;

import java.util.ArrayList;
import java.util.List;

import static oreregistry.api.registry.ProductTypes.*;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import oreregistry.api.OreRegistryApi;
import oreregistry.api.registry.IResource;
import oreregistry.api.registry.IResourceRegistry;
import oreregistry.api.registry.ResourceTypes;
import oreregistry.config.Constants;
import oreregistry.util.ResourceInfo;
import oreregistry.util.ResourceRegistry;

@Mod(modid = Constants.MOD_ID, name = Constants.NAME, version = Constants.VERSION, acceptedMinecraftVersions = "[1.11]")
public class OreRegistry {
	public static final ResourceInfo helper;
	public static final List<ItemStack> unusedItems = new ArrayList<>();

	static {
		OreRegistryApi.registry = new ResourceRegistry();
		OreRegistryApi.info = helper = new ResourceInfo();
	}

	@EventHandler
	public static void preInit(FMLPreInitializationEvent event) {
		registerVanilla(OreRegistryApi.registry);
		MinecraftForge.EVENT_BUS.register(new oreregistry.EventHandler());
	}

	private static void registerVanilla(IResourceRegistry resourceRegistry) {
		final IResource iron = resourceRegistry.registerResource(ResourceTypes.IRON);
		iron.registerProduct(INGOT, new ItemStack(Items.field_151042_j));
		iron.registerProduct(NUGGET, new ItemStack(Items.field_191525_da));
		iron.registerProduct(BLOCK, new ItemStack(Blocks.field_150339_S));
		iron.registerProduct(ORE, new ItemStack(Blocks.field_150366_p));

		final IResource gold = resourceRegistry.registerResource(ResourceTypes.GOLD);
		gold.registerProduct(INGOT, new ItemStack(Items.field_151043_k));
		gold.registerProduct(NUGGET, new ItemStack(Items.field_151074_bl));
		gold.registerProduct(BLOCK, new ItemStack(Blocks.field_150340_R));
		gold.registerProduct(ORE, new ItemStack(Blocks.field_150352_o));

		final IResource emerald = resourceRegistry.registerResource(ResourceTypes.EMERALD);
		emerald.registerProduct(GEM, new ItemStack(Items.field_151166_bC));
		emerald.registerProduct(BLOCK, new ItemStack(Blocks.field_150475_bE));
		emerald.registerProduct(ORE, new ItemStack(Blocks.field_150412_bA));

		final IResource diamond = resourceRegistry.registerResource(ResourceTypes.DIAMOND);
		diamond.registerProduct(GEM, new ItemStack(Items.field_151045_i));
		diamond.registerProduct(BLOCK, new ItemStack(Blocks.field_150484_ah));
		diamond.registerProduct(ORE, new ItemStack(Blocks.field_150482_ag));

		final IResource lapis = resourceRegistry.registerResource(ResourceTypes.LAPIS);
		lapis.registerProduct(GEM, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
		lapis.registerProduct(BLOCK, new ItemStack(Blocks.field_150368_y));
		lapis.registerProduct(ORE, new ItemStack(Blocks.field_150369_x));

		final IResource redstone = resourceRegistry.registerResource(ResourceTypes.REDSTONE);
		redstone.registerProduct(DUST, new ItemStack(Items.field_151137_ax));
		redstone.registerProduct(BLOCK, new ItemStack(Blocks.field_150451_bX));
		redstone.registerProduct(ORE, new ItemStack(Blocks.field_150450_ax));

		final IResource quartz = resourceRegistry.registerResource(ResourceTypes.QUARTZ);
		quartz.registerProduct(GEM, new ItemStack(Items.field_151128_bU));
		quartz.registerProduct(BLOCK, new ItemStack(Blocks.field_150371_ca));
		quartz.registerProduct(ORE, new ItemStack(Blocks.field_150449_bY));

		final IResource coal = resourceRegistry.registerResource(ResourceTypes.COAL);
		coal.registerProduct(GEM, new ItemStack(Items.field_151044_h));
		coal.registerProduct(BLOCK, new ItemStack(Blocks.field_150402_ci));
		coal.registerProduct(ORE, new ItemStack(Blocks.field_150365_q));
	}
}
