/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.network;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oreregistry.OreRegistry;
import oreregistry.api.OreRegistryState;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;
import oreregistry.util.Log;
import oreregistry.util.Product;
import oreregistry.util.ProductUtils;
import oreregistry.util.ResourceRegistry;

public class PacketHandler {
    public static final String channelId = "or";
    private static FMLEventChannel channel;

    public PacketHandler() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelId);
        channel.register((Object)this);
    }

    public static void sendToClients(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP) || player instanceof FakePlayer) {
            return;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        Map<String, IResource> resources = OreRegistry.registry.getRegisteredResources();
        buffer.func_150787_b(resources.size());
        for (Map.Entry<String, IResource> resourceEntry : resources.entrySet()) {
            IResource resource = resourceEntry.getValue();
            PacketHandler.writeResource(buffer, resource);
        }
        channel.sendTo(new FMLProxyPacket(buffer, channelId), (EntityPlayerMP)player);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        PacketBuffer buffer = new PacketBuffer(event.getPacket().payload());
        PacketHandler.checkThreadAndEnqueue(buffer, (IThreadListener)Minecraft.func_71410_x());
    }

    @SideOnly(value=Side.CLIENT)
    private static void checkThreadAndEnqueue(PacketBuffer buffer, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                Preconditions.checkNotNull((Object)player, (Object)"Tried to send data to client before the player exists.");
                ResourceRegistry registry = OreRegistry.registry;
                registry.setState(OreRegistryState.SYNCHRONIZE);
                for (int size = buffer.func_150792_a(); size > 0; --size) {
                    PacketHandler.readResource(buffer);
                }
                registry.setState(OreRegistryState.INACTIVE);
            });
        }
    }

    private static void writeResource(PacketBuffer buffer, IResource resource) {
        String resourceType = resource.getType();
        buffer.func_180714_a(resourceType);
        Map<String, IProduct> products = resource.getRegisteredProducts();
        buffer.func_150787_b(products.size());
        for (Map.Entry<String, IProduct> productEntry : products.entrySet()) {
            String productType = productEntry.getKey();
            try {
                buffer.func_180714_a(productType);
                IProduct product = productEntry.getValue();
                if (product instanceof Product) {
                    buffer.writeInt(((Product)product).getChosenProductIndex());
                    continue;
                }
                buffer.writeInt(0);
            }
            catch (Exception e) {
                Log.error("Failed to synchronise a product of the type " + productType + " with the client.", e);
            }
        }
    }

    private static void readResource(PacketBuffer buffer) {
        OreRegistry.unusedItems.clear();
        String resourceType = buffer.func_150789_c(1024);
        IResource resource = OreRegistry.registry.registerResource(resourceType);
        int products = buffer.func_150792_a();
        for (int i = 0; i < products; ++i) {
            String productType = buffer.func_150789_c(1024);
            try {
                IProduct product = resource.getProduct(productType);
                int index = buffer.readInt();
                if (!(product instanceof Product)) continue;
                ProductUtils.chooseProduct((Product)product, index);
                continue;
            }
            catch (Exception e) {
                Log.error("Failed to synchronise a product of the type " + productType + " with the server.", e);
            }
        }
    }
}

