/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import oreregistry.OreRegistry;
import oreregistry.api.ChoseProductEvent;
import oreregistry.api.OreRegistryState;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;

public class Product
implements IProduct {
    private final List<ItemStack> variants = new ArrayList<ItemStack>();
    private final IResource resource;
    private final String type;
    private ItemStack chosenProduct;
    private int chosenProductIndex;

    public Product(IResource resource, String type) {
        this.resource = resource;
        this.chosenProduct = ItemStack.field_190927_a;
        this.type = type;
    }

    void choseProduct(ItemStack chosenProduct, int chosenProductIndex) {
        OreRegistryState state = OreRegistry.registry.getState();
        if (state != OreRegistryState.CHOOSE && state != OreRegistryState.SYNCHRONIZE) {
            return;
        }
        if (chosenProduct.func_190926_b()) {
            this.chosenProduct = ItemStack.field_190927_a;
            return;
        }
        this.chosenProductIndex = chosenProductIndex;
        this.chosenProduct = chosenProduct;
        MinecraftForge.EVENT_BUS.post((Event)new ChoseProductEvent(this, chosenProduct, chosenProductIndex));
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int getChosenProductIndex() {
        return this.chosenProductIndex;
    }

    @Override
    public List<ItemStack> getVariants() {
        return Collections.unmodifiableList(this.variants);
    }

    @Override
    public ItemStack getChosenProduct() {
        if (this.chosenProduct.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return this.chosenProduct.func_77946_l();
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    void addVariant(ItemStack variant) {
        Preconditions.checkNotNull((Object)variant, (Object)"Product must not be null");
        Preconditions.checkArgument((!variant.func_190926_b() ? 1 : 0) != 0, (Object)"Product must not be empty");
        variant = variant.func_77946_l();
        variant.func_190920_e(1);
        OreRegistry.helper.registerResourceItem(variant, this.resource);
        this.variants.add(variant);
    }
}

