/*
 * Decompiled with CFR 0.152.
 */
package oreregistry.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import oreregistry.OreRegistry;
import oreregistry.api.IUnificationHandler;
import oreregistry.api.OreRegistryApi;
import oreregistry.api.info.IProductInfo;
import oreregistry.api.info.IResourceInfo;
import oreregistry.api.registry.IProduct;
import oreregistry.api.registry.IResource;
import oreregistry.util.ProductInfo;
import oreregistry.util.ProductUtils;

public class ResourceInfo
implements IResourceInfo {
    private final Map<Item, List<IResource>> resourceItems = new IdentityHashMap<Item, List<IResource>>();

    @Override
    @Nullable
    public IProductInfo getProductInfo(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack must not be null");
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"itemStack must not be empty");
        Item item = itemStack.func_77973_b();
        List<IResource> resources = this.resourceItems.get(item);
        if (resources != null) {
            for (IResource resource : resources) {
                Map<String, IProduct> registeredProducts = resource.getRegisteredProducts();
                for (Map.Entry<String, IProduct> entry : registeredProducts.entrySet()) {
                    IProduct product = entry.getValue();
                    for (ItemStack variant : product.getVariants()) {
                        if (!ProductUtils.needUnification(itemStack, variant)) continue;
                        String productType = entry.getKey();
                        ItemStack chosenProduct = product.getChosenProduct();
                        return new ProductInfo(resource.getType(), productType, ProductUtils.needUnification(itemStack, chosenProduct));
                    }
                }
            }
        }
        return null;
    }

    @Override
    public ItemStack tryUnifyItem(ItemStack oldStack) {
        IProductInfo productInfo = this.getProductInfo(oldStack);
        if (productInfo != null) {
            IResource resource = OreRegistry.registry.getResource(productInfo.getResourceType());
            if (resource == null) {
                return ItemStack.field_190927_a;
            }
            IProduct product = resource.getProduct(productInfo.getProductType());
            if (product == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack newStack = product.getChosenProduct();
            if (ProductUtils.needUnification(oldStack, newStack)) {
                return ItemStack.field_190927_a;
            }
            newStack.func_190920_e(oldStack.func_190916_E());
            for (IUnificationHandler handler : OreRegistryApi.registry.getUnificationHandlers(resource.getType())) {
                handler.onUnifyItem(oldStack, newStack, product);
            }
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    public void registerResourceItem(ItemStack itemStack, IResource resource) {
        Item item = itemStack.func_77973_b();
        List resources = this.resourceItems.computeIfAbsent(item, k -> new ArrayList());
        resources.add(resource);
    }
}

