/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import net.minecraftforge.fml.common.API;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;

public abstract class ModUtil {
    public static boolean isModLoaded(String modname) {
        return Loader.isModLoaded((String)modname);
    }

    public static boolean isModLoaded(String modname, String versionRangeString) {
        if (!ModUtil.isModLoaded(modname)) {
            return false;
        }
        if (versionRangeString != null) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modname);
            ArtifactVersion modVersion = mod.getProcessedVersion();
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(modname, versionRange);
            if (!requiredVersion.containsVersion(modVersion)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAPILoaded(String apiName) {
        return ModUtil.isAPILoaded(apiName, null);
    }

    public static boolean isAPILoaded(String apiName, String versionRangeString) {
        Package apiPackage = Package.getPackage(apiName);
        if (apiPackage == null) {
            return false;
        }
        API apiAnnotation = apiPackage.getAnnotation(API.class);
        if (apiAnnotation == null) {
            return false;
        }
        if (versionRangeString != null) {
            DefaultArtifactVersion givenVersion;
            String apiVersionString = apiAnnotation.apiVersion();
            if (apiVersionString == null) {
                return false;
            }
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(apiName, versionRange);
            if (!requiredVersion.containsVersion((ArtifactVersion)(givenVersion = new DefaultArtifactVersion(apiName, apiVersionString)))) {
                return false;
            }
        }
        return true;
    }
}

