/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.VectUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial() {
        super("glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vec3i area = genome.getTerritory();
        BlockPos offset = VectUtil.scale(area, -0.5f);
        BlockPos housingCoords = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);
            BlockPos posBlock = VectUtil.add(new Vec3i[]{randomPos, housingCoords, offset});
            Block block = world.func_180495_p(posBlock).func_177230_c();
            if (block != Blocks.field_150355_j || !world.func_175623_d(new BlockPos(posBlock.func_177958_n(), posBlock.func_177956_o() + 1, posBlock.func_177952_p()))) continue;
            world.func_175656_a(posBlock, Blocks.field_150432_aD.func_176223_P());
        }
        return storedData;
    }
}

