/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.BeverageManager;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.LiquidRegistryHelper;
import forestry.core.recipes.RecipeUtil;
import forestry.food.BeverageEffects;
import forestry.food.InfuserIngredientManager;
import forestry.food.InfuserMixtureManager;
import forestry.food.items.EnumBeverage;
import forestry.food.items.ItemRegistryFood;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

@ForestryPlugin(pluginID="forestry.food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.food.description")
public class PluginFood
extends BlankForestryPlugin {
    public static ItemRegistryFood items;

    @Override
    public void setupAPI() {
        super.setupAPI();
        BeverageManager.infuserManager = new InfuserMixtureManager();
        BeverageManager.ingredientManager = new InfuserIngredientManager();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryFood();
    }

    @Override
    public void preInit() {
        LiquidRegistryHelper.registerLiquidContainer(Fluids.SHORT_MEAD, 1000, PluginFood.items.beverage.get(EnumBeverage.MEAD_SHORT, 1), new ItemStack(Items.field_151069_bo));
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            ItemStack normalPollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.NORMAL, 1);
            ItemStack crystallinePollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1);
            BeverageManager.ingredientManager.addIngredient(normalPollenCluster, "Strong Curative");
            BeverageManager.ingredientManager.addIngredient(crystallinePollenCluster, "Weak Curative");
            BeverageManager.infuserManager.addMixture(1, normalPollenCluster, BeverageEffects.strongAntidote);
            BeverageManager.infuserManager.addMixture(1, crystallinePollenCluster, BeverageEffects.weakAntidote);
        }
    }

    @Override
    public void registerRecipes() {
        RecipeUtil.addRecipe(PluginFood.items.infuser.getItemStack(), "X", "#", "X", Character.valueOf('#'), "ingotIron", Character.valueOf('X'), "ingotBronze");
    }
}

