/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.core.fluids.Fluids;
import forestry.core.items.DrinkProperties;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemLiquidContainerDrinkable;
import forestry.core.items.ItemRegistry;

public class ItemRegistryFluids
extends ItemRegistry {
    public final ItemLiquidContainer canEmpty;
    public final ItemLiquidContainer waxCapsuleEmpty;
    public final ItemLiquidContainer refractoryEmpty;
    private final Table<EnumContainerType, String, ItemLiquidContainer> containers = HashBasedTable.create();

    public ItemLiquidContainer getContainer(EnumContainerType type, Fluids fluid) {
        return (ItemLiquidContainer)this.containers.get((Object)type, (Object)fluid.getFluid().getName());
    }

    public ItemRegistryFluids() {
        this.canEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.CAN, "can.empty");
        this.waxCapsuleEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.CAPSULE, "capsule.empty");
        this.refractoryEmpty = ItemRegistryFluids.registerEmptyContainer(EnumContainerType.REFRACTORY, "refractory.empty");
        for (Fluids fluidType : Fluids.values()) {
            if (fluidType.getFluid() == null) continue;
            for (EnumContainerType type : fluidType.getContainerTypes()) {
                int color = fluidType.getColor().getRGB();
                DrinkProperties drinkProperties = fluidType.getDrinkProperties();
                ItemLiquidContainer liquidContainer = drinkProperties == null ? new ItemLiquidContainer(type, color) : new ItemLiquidContainerDrinkable(type, color, drinkProperties);
                String name = type.getName() + '.' + fluidType.getTag();
                ItemRegistryFluids.registerItem(liquidContainer, name);
                this.containers.put((Object)type, (Object)fluidType.getFluid().getName(), (Object)liquidContainer);
            }
        }
    }

    private static ItemLiquidContainer registerEmptyContainer(EnumContainerType type, String name) {
        return ItemRegistryFluids.registerItem(new ItemLiquidContainer(type, 0), name);
    }
}

