/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.access.IAccessHandler;
import forestry.core.config.Constants;
import forestry.core.inventory.InventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryAdapterRestricted
extends InventoryAdapter {
    private final IAccessHandler accessHandler;

    public InventoryAdapterRestricted(int size, String name, IAccessHandler accessHandler) {
        super(size, name);
        this.accessHandler = accessHandler;
    }

    public InventoryAdapterRestricted(int size, String name, int stackLimit, IAccessHandler accessHandler) {
        super(size, name, stackLimit);
        this.accessHandler = accessHandler;
    }

    @Override
    public final boolean func_70300_a(EntityPlayer player) {
        return this.accessHandler.allowsViewing(player);
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (itemStack == null || !this.accessHandler.allowsPipeConnections()) {
            return false;
        }
        return this.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (!this.accessHandler.allowsPipeConnections()) {
            return Constants.SLOTS_NONE;
        }
        return super.func_180463_a(side);
    }

    @Override
    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (itemStack == null || !this.accessHandler.allowsPipeConnections()) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return itemStack != null && this.accessHandler.allowsPipeConnections();
    }
}

