/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileFruitPod
extends TileEntity
implements IFruitBearer,
IStreamable {
    private static final short MAX_MATURITY = 2;
    private IAlleleFruit allele;
    private short maturity;
    private float sappiness;

    public TileFruitPod() {
        Log.debug("Made a fruit pod", new Object[0]);
    }

    public void setProperties(IAlleleFruit allele, float sappiness) {
        this.allele = allele;
        this.sappiness = sappiness;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        IAllele stored = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i("UID"));
        this.allele = stored instanceof IAlleleFruit ? (IAlleleFruit)stored : (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("Forestry.fruitCocoa");
        this.maturity = nbttagcompound.func_74765_d("MT");
        this.sappiness = nbttagcompound.func_74760_g("SP");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.allele != null) {
            nbttagcompound.func_74778_a("UID", this.allele.getUID());
        }
        nbttagcompound.func_74777_a("MT", this.maturity);
        nbttagcompound.func_74776_a("SP", this.sappiness);
    }

    public void onBlockTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.canMature() && rand.nextFloat() <= this.sappiness) {
            this.addRipeness(0.5f);
        }
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    public short getMaturity() {
        return this.maturity;
    }

    @Nullable
    public ItemStack getPickBlock() {
        Map<ItemStack, Float> products = this.allele.getProvider().getProducts();
        ItemStack pickBlock = null;
        Float maxChance = Float.valueOf(0.0f);
        for (Map.Entry<ItemStack, Float> product : products.entrySet()) {
            if (!(maxChance.floatValue() < product.getValue().floatValue())) continue;
            maxChance = product.getValue();
            pickBlock = product.getKey().func_77946_l();
        }
        pickBlock.field_77994_a = 1;
        return pickBlock;
    }

    public List<ItemStack> getDrops() {
        return this.allele.getProvider().getFruits(null, this.field_145850_b, this.func_174877_v(), this.maturity);
    }

    public Packet func_145844_m() {
        return new PacketTileStream(this).getPacket();
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        return this.allele.getProvider().getFamily();
    }

    @Override
    public Collection<ItemStack> pickFruit(ItemStack tool) {
        List<ItemStack> fruits = this.getDrops();
        this.maturity = 0;
        IBlockState oldState = this.field_145850_b.func_180495_p(this.func_174877_v());
        IBlockState newState = oldState.func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0));
        BlockUtil.setBlockWithBreakSound(this.field_145850_b, this.func_174877_v(), newState, oldState);
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        int age;
        int previousAge = (int)Math.floor(this.maturity);
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        if (this.maturity > 2) {
            this.maturity = (short)2;
        }
        if ((age = (int)Math.floor(this.maturity)) - previousAge > 0) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(age));
            this.field_145850_b.func_175656_a(this.func_174877_v(), state);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.allele != null) {
            data.writeUTF(this.allele.getUID());
        } else {
            data.writeUTF("");
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        IAllele stored = AlleleManager.alleleRegistry.getAllele(data.readUTF());
        this.allele = stored instanceof IAlleleFruit ? (IAlleleFruit)stored : (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("Forestry.fruitCocoa");
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }
}

