/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.proxy.Proxies;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleHelper {
    private static final Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static boolean addBlockHitEffects(World world, BlockPos pos, EnumFacing side, EffectRenderer effectRenderer, Callback callback) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double px = (double)x + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
            double py = (double)y + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
            double pz = (double)z + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                py = (double)y + axisalignedbb.field_72338_b - (double)f;
            }
            if (side == EnumFacing.UP) {
                py = (double)y + axisalignedbb.field_72337_e + (double)f;
            }
            if (side == EnumFacing.NORTH) {
                pz = (double)z + axisalignedbb.field_72339_c - (double)f;
            }
            if (side == EnumFacing.SOUTH) {
                pz = (double)z + axisalignedbb.field_72334_f + (double)f;
            }
            if (side == EnumFacing.WEST) {
                px = (double)x + axisalignedbb.field_72340_a - (double)f;
            }
            if (side == EnumFacing.EAST) {
                px = (double)x + axisalignedbb.field_72336_d + (double)f;
            }
            EntityDiggingFX fx = (EntityDiggingFX)effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), px, py, pz, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            callback.addHitEffects(fx, world, pos, iblockstate);
            effectRenderer.func_78873_a(fx.func_174846_a(new BlockPos(x, y, z)).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, Block block, IBlockState state, BlockPos pos, EffectRenderer effectRenderer, Callback callback) {
        if (block != state.func_177230_c()) {
            return true;
        }
        int iterations = 4;
        for (int i = 0; i < iterations; ++i) {
            for (int j = 0; j < iterations; ++j) {
                for (int k = 0; k < iterations; ++k) {
                    double px = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)iterations;
                    double py = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)iterations;
                    double pz = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)iterations;
                    int random = rand.nextInt(6);
                    EntityDiggingFX fx = (EntityDiggingFX)effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), px, py, pz, px - (double)pos.func_177958_n() - 0.5, py - (double)pos.func_177956_o() - 0.5, pz - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    callback.addDestroyEffects(fx, world, pos, state);
                    effectRenderer.func_78873_a((EntityFX)fx.func_174846_a(pos));
                }
            }
        }
        return true;
    }

    public static class DefaultCallback<B extends Block>
    implements Callback {
        protected final B block;

        public DefaultCallback(B block) {
            this.block = block;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX fx, World world, BlockPos pos, IBlockState state) {
            this.setTexture(fx, world, pos, state);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX fx, World world, BlockPos pos, IBlockState state) {
            this.setTexture(fx, world, pos, state);
        }

        @SideOnly(value=Side.CLIENT)
        protected void setTexture(EntityDiggingFX fx, World world, BlockPos pos, IBlockState state) {
            Minecraft minecraft = Proxies.common.getClientInstance();
            BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
            BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
            TextureAtlasSprite texture = blockModelShapes.func_178122_a(state);
            fx.func_187117_a(texture);
        }
    }

    public static interface Callback {
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX var1, World var2, BlockPos var3, IBlockState var4);

        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX var1, World var2, BlockPos var3, IBlockState var4);
    }
}

