/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;

public class AlleleEffectFungification
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public AlleleEffectFungification() {
        super("mycophilic", true, 10, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData && ((EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            AlleleEffectFungification.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IBeeGenome genome, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vec3i area = this.getModifiedArea(genome, housing);
        int blockX = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177958_n(), area.func_177958_n());
        int blockY = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177956_o(), area.func_177956_o());
        int blockZ = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177952_p(), area.func_177952_p());
        for (int attempt = 0; attempt < 10; ++attempt) {
            BlockPos pos = new BlockPos(blockX, blockY, blockZ);
            Block block = world.func_180495_p(pos).func_177230_c();
            if (AlleleEffectFungification.isSuitableForMycelium(world, block, pos)) {
                world.func_175656_a(pos, Blocks.field_150391_bh.func_176223_P());
                break;
            }
            if (AlleleEffectFungification.isSuitableForGrowth(block)) {
                AlleleEffectFungification.doMushroomGrowth(block, world, pos);
                break;
            }
            blockX = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177958_n(), area.func_177958_n());
            blockY = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177956_o(), area.func_177956_o());
            blockZ = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.func_177952_p(), area.func_177952_p());
        }
    }

    private static void doEntityEffect(IBeeGenome genome, IBeeHousing housing) {
        List<EntityCow> cows = AlleleEffectFungification.getEntitiesInRange(genome, housing, EntityCow.class);
        for (EntityCow cow : cows) {
            AlleleEffectFungification.convertCowToMooshroom(cow);
        }
    }

    private static int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private static boolean isSuitableForMycelium(World world, Block block, BlockPos pos) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d && world.func_175710_j(pos);
    }

    private static boolean isSuitableForGrowth(Block block) {
        return block == Blocks.field_150337_Q || block == Blocks.field_150338_P;
    }

    private static void convertCowToMooshroom(EntityCow cow) {
        if (cow instanceof EntityMooshroom) {
            return;
        }
        World worldObj = cow.field_70170_p;
        cow.func_70106_y();
        EntityMooshroom mooshroom = new EntityMooshroom(worldObj);
        mooshroom.func_70012_b(cow.field_70165_t, cow.field_70163_u, cow.field_70161_v, cow.field_70177_z, cow.field_70125_A);
        mooshroom.func_70606_j(cow.func_110143_aJ());
        mooshroom.field_70761_aq = cow.field_70761_aq;
        worldObj.func_72838_d((Entity)mooshroom);
        worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, cow.field_70165_t, cow.field_70163_u + (double)(cow.field_70131_O / 2.0f), cow.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    private static void doMushroomGrowth(Block block, World world, BlockPos pos) {
        WorldGenBigMushroom giantMushroomGenerator = new WorldGenBigMushroom(block);
        world.func_175698_g(pos);
        giantMushroomGenerator.func_180709_b(world, world.field_73012_v, pos);
    }
}

