/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.logic;

import java.util.ArrayList;
import java.util.Collection;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmHousing;

public class FarmLogicMushroom extends FarmLogicArboreal {

	public FarmLogicMushroom() {
		super(new ItemStack(Blocks.MYCELIUM), Blocks.MYCELIUM.getDefaultState(), Farmables.farmables.get("farmShroom"));
	}

	@Override
	public String getName() {
		if (isManual) {
			return "Manual Shroom Farm";
		} else {
			return "Managed Shroom Farm";
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public Item getItem() {
		return Item.getItemFromBlock(Blocks.RED_MUSHROOM);
	}

	@Override
	public int getFertilizerConsumption() {
		return 20;
	}

	@Override
	public int getWaterConsumption(float hydrationModifier) {
		return (int) (80 * hydrationModifier);
	}

	@Override
	public Collection<ItemStack> collect(World world, IFarmHousing farmHousing) {
		Collection<ItemStack> products = produce;
		produce = new ArrayList<>();
		return products;
	}

}
