/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.gui.IGuiSelectable;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.network.packets.PacketLetterInfoResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerCatalogue
extends Container
implements IGuiSelectable,
ILetterInfoReceiver {
    private final EntityPlayer player;
    private final List<ITradeStation> stations = new ArrayList<ITradeStation>();
    private ITradeStationInfo currentTrade = null;
    private int stationIndex = 0;
    private int stationCount;
    private boolean needsSynch = true;
    private int currentFilter = 1;
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final List<Set<IPostalState>> FILTERS = new ArrayList<Set<IPostalState>>();

    public ContainerCatalogue(EntityPlayer player) {
        this.player = player;
        if (!player.field_70170_p.field_72995_K) {
            this.rebuildStationsList();
        }
    }

    public int getPageCount() {
        return Math.max(this.stationCount, 1);
    }

    public int getPageNumber() {
        return this.stationIndex + 1;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter];
    }

    private void rebuildStationsList() {
        this.stations.clear();
        IPostOffice postOffice = PostManager.postRegistry.getPostOffice(this.player.field_70170_p);
        Map<IMailAddress, ITradeStation> tradeStations = postOffice.getActiveTradeStations(this.player.field_70170_p);
        for (ITradeStation station : tradeStations.values()) {
            ITradeStationInfo info = station.getTradeInfo();
            if (info.getTradegood() == null || !FILTERS.get(this.currentFilter).contains(info.getState())) continue;
            this.stations.add(station);
        }
        this.stationIndex = 0;
        this.updateTradeInfo();
    }

    public void nextPage() {
        if (this.player.field_70170_p.field_72995_K) {
            ContainerCatalogue.sendSelection(true);
            return;
        }
        if (this.stations.isEmpty()) {
            return;
        }
        this.stationIndex = (this.stationIndex + 1) % this.stations.size();
        this.updateTradeInfo();
    }

    public void previousPage() {
        if (this.player.field_70170_p.field_72995_K) {
            ContainerCatalogue.sendSelection(false);
            return;
        }
        if (this.stations.isEmpty()) {
            return;
        }
        this.stationIndex = (this.stationIndex - 1 + this.stations.size()) % this.stations.size();
        this.updateTradeInfo();
    }

    public void cycleFilter() {
        if (this.player.field_70170_p.field_72995_K) {
            Proxies.net.sendToServer(new PacketGuiSelectRequest(2, 0));
            return;
        }
        this.currentFilter = (this.currentFilter + 1) % FILTERS.size();
        this.rebuildStationsList();
    }

    private static void sendSelection(boolean advance) {
        int value = advance ? 0 : 1;
        Proxies.net.sendToServer(new PacketGuiSelectRequest(value, 0));
    }

    private void updateTradeInfo() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.stations.isEmpty()) {
            ITradeStation station = this.stations.get(this.stationIndex);
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSynch = true;
    }

    @Override
    public void handleLetterInfoUpdate(PacketLetterInfoResponse packet) {
        this.setTradeInfo(packet.tradeInfo);
    }

    public ITradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(ITradeStationInfo info) {
        this.currentTrade = info;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.needsSynch) {
            for (ICrafting crafter : this.field_75149_d) {
                crafter.func_71112_a((Container)this, 0, this.stationIndex);
                crafter.func_71112_a((Container)this, 1, this.stations.size());
                crafter.func_71112_a((Container)this, 2, this.currentFilter);
            }
            Proxies.net.sendToPlayer(new PacketLetterInfoResponse(EnumAddressee.TRADER, this.currentTrade, null), this.player);
            this.needsSynch = false;
        }
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.stationIndex = j;
                break;
            }
            case 1: {
                this.stationCount = j;
                break;
            }
            case 2: {
                this.currentFilter = j;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        switch (packet.getPrimaryIndex()) {
            case 0: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
                break;
            }
            case 2: {
                this.cycleFilter();
            }
        }
        this.needsSynch = true;
    }

    static {
        EnumSet<EnumTradeStationState> all = EnumSet.allOf(EnumTradeStationState.class);
        EnumSet<EnumTradeStationState> online = EnumSet.of(EnumTradeStationState.OK);
        EnumSet<EnumTradeStationState> offline = EnumSet.copyOf(all);
        offline.removeAll(online);
        FILTERS.add(Collections.unmodifiableSet(all));
        FILTERS.add(Collections.unmodifiableSet(online));
        FILTERS.add(Collections.unmodifiableSet(offline));
    }
}

