/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics.alleles;

import forestry.api.genetics.AlleleManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.core.PluginCore;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.lepidopterology.blocks.property.PropertyCocoon;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;

public class AlleleButterflyCocoon
extends AlleleCategorized
implements IAlleleButterflyCocoon {
    public static final PropertyCocoon COCOON = new PropertyCocoon("cocoon");
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    public static IAlleleButterflyCocoon cocoonDefault;
    public static IAlleleButterflyCocoon cocoonSilk;
    private static List<IAlleleButterflyCocoon> cocoonAlleles;
    private final Map<ItemStack, Float> loot = new HashMap<ItemStack, Float>();
    private final String name;

    public static void createAlleles() {
        cocoonDefault = new AlleleButterflyCocoon("default", false);
        cocoonSilk = new AlleleButterflyCocoon("silk", false);
        List<IAlleleButterflyCocoon> cocoonAlleles = Arrays.asList(cocoonDefault, cocoonSilk);
        for (IAlleleButterflyCocoon cocoonAllele : cocoonAlleles) {
            AlleleManager.alleleRegistry.registerAllele(cocoonAllele, EnumButterflyChromosome.COCOON);
        }
    }

    public static void createLoot() {
        cocoonSilk.getCocoonLoot().put(PluginCore.items.craftingMaterial.getSilkWisp(), Float.valueOf(0.75f));
        cocoonSilk.getCocoonLoot().put(PluginCore.items.craftingMaterial.getSilkWisp(), Float.valueOf(0.25f));
    }

    public AlleleButterflyCocoon(String name, boolean isDominant) {
        super("Forestry", "cocoon", name, isDominant);
        this.name = name;
    }

    private static String getAgeKey(int age) {
        if (age == 0) {
            return "early";
        }
        if (age == 1) {
            return "middle";
        }
        return "late";
    }

    @Override
    public String getCocoonName() {
        return this.name;
    }

    @Override
    public ModelResourceLocation getCocoonItemModel(int age) {
        return new ModelResourceLocation("forestry:lepidopterology/cocoons/cocoon_" + this.name + "_" + AlleleButterflyCocoon.getAgeKey(age), "inventory");
    }

    @Override
    public Map<ItemStack, Float> getCocoonLoot() {
        return this.loot;
    }

    @Override
    public int compareTo(@Nonnull IAlleleButterflyCocoon o) {
        return 0;
    }
}

