/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicPeat
extends FarmLogicWatered {
    private static final ItemStack bogEarth = PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 1);

    public FarmLogicPeat() {
        super(bogEarth, PluginCore.blocks.bogEarth.func_176223_P());
    }

    @Override
    public boolean isAcceptedGround(IBlockState blockState) {
        if (super.isAcceptedGround(blockState)) {
            return true;
        }
        return blockState.func_177230_c() == PluginCore.blocks.bogEarth;
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockBogEarth.SoilType soilType;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState blockState = world.func_180495_p(position);
            Block block = blockState.func_177230_c();
            if (!(block instanceof BlockBogEarth) || (soilType = BlockBogEarth.getTypeFromState(blockState)) != BlockBogEarth.SoilType.PEAT) continue;
            crops.push(new CropPeat(world, position));
        }
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return PluginCore.items.peat;
    }
}

