/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Individual
implements IIndividual {
    protected boolean isAnalyzed;

    protected Individual() {
        this.isAnalyzed = false;
    }

    protected Individual(@Nonnull NBTTagCompound nbt) {
        this.isAnalyzed = nbt.func_74767_n("IsAnalyzed");
    }

    @Override
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    @Override
    public boolean analyze() {
        if (this.isAnalyzed) {
            return false;
        }
        this.isAnalyzed = true;
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("IsAnalyzed", this.isAnalyzed);
    }

    @Override
    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    @Override
    public String getDisplayName() {
        return this.getGenome().getPrimary().getName();
    }

    @Override
    public boolean hasEffect() {
        return this.getGenome().getPrimary().hasEffect();
    }

    @Override
    public boolean isSecret() {
        return this.getGenome().getPrimary().isSecret();
    }

    @Override
    public boolean isGeneticEqual(IIndividual other) {
        return this.getGenome().isGeneticEqual(other.getGenome());
    }

    @Override
    public boolean isPureBred(IChromosomeType chromosomeType) {
        return this.getGenome().getActiveAllele(chromosomeType).getUID().equals(this.getGenome().getInactiveAllele(chromosomeType).getUID());
    }
}

