/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenLemon
extends WorldGenTree {
    public WorldGenLemon(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 2 ? yCenter : 3;
        int radius = Math.round((float)(2 + rand.nextInt(this.girth)) * ((float)this.height / 4.0f));
        if (radius > 4) {
            radius = 4;
        }
        WorldGenHelper.generateSphereFromTreeStartPos(world, startPos.func_177982_a(0, yCenter, 0), this.girth, radius, leaf, WorldGenHelper.EnumReplaceMode.AIR);
    }
}

