/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.core.IModelManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ModelProviderGermling
implements IGermlingModelProvider {
    private final String name;
    private ModelResourceLocation germlingModel;
    private ModelResourceLocation pollenModel;
    private ModelResourceLocation charcoalModel;

    public ModelProviderGermling(String modelUid) {
        this.name = modelUid.substring("forestry.".length());
    }

    @Override
    public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
        if (type == EnumGermlingType.SAPLING) {
            this.germlingModel = manager.getModelLocation("germlings/sapling." + this.name);
            manager.registerVariant(item, new ResourceLocation("forestry:germlings/sapling." + this.name));
        } else if (type == EnumGermlingType.POLLEN) {
            this.pollenModel = manager.getModelLocation("pollen");
            manager.registerVariant(item, new ResourceLocation("forestry:pollen"));
        } else if (type == EnumGermlingType.CHARCOAL) {
            this.charcoalModel = manager.getModelLocation("charcoal");
            manager.registerVariant(item, new ResourceLocation("forestry:charcoal"));
        }
    }

    @Override
    @Nonnull
    public ModelResourceLocation getModel(EnumGermlingType type) {
        if (type == EnumGermlingType.POLLEN) {
            return this.pollenModel;
        }
        if (type == EnumGermlingType.CHARCOAL) {
            return this.charcoalModel;
        }
        return this.germlingModel;
    }
}

