/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.core.IModelManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;

public class ModelProviderGermlingVanilla
implements IGermlingModelProvider {
    private final EnumVanillaWoodType woodType;
    private ModelResourceLocation germlingModel;
    private ModelResourceLocation pollenModel;
    private ModelResourceLocation charcoalModel;

    public ModelProviderGermlingVanilla(EnumVanillaWoodType woodType) {
        this.woodType = woodType;
    }

    @Override
    public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
        if (type == EnumGermlingType.SAPLING) {
            switch (this.woodType) {
                case OAK: {
                    this.germlingModel = manager.getModelLocation("minecraft", "oak_sapling");
                    break;
                }
                case SPRUCE: {
                    this.germlingModel = manager.getModelLocation("minecraft", "spruce_sapling");
                    break;
                }
                case BIRCH: {
                    this.germlingModel = manager.getModelLocation("minecraft", "birch_sapling");
                    break;
                }
                case JUNGLE: {
                    this.germlingModel = manager.getModelLocation("minecraft", "jungle_sapling");
                    break;
                }
                case ACACIA: {
                    this.germlingModel = manager.getModelLocation("minecraft", "acacia_sapling");
                    break;
                }
                case DARK_OAK: {
                    this.germlingModel = manager.getModelLocation("minecraft", "dark_oak_sapling");
                }
            }
        } else if (type == EnumGermlingType.POLLEN) {
            this.pollenModel = manager.getModelLocation("pollen");
        } else if (type == EnumGermlingType.CHARCOAL) {
            this.charcoalModel = manager.getModelLocation("minecraft", "charcoal");
        }
    }

    @Override
    @Nonnull
    public ModelResourceLocation getModel(EnumGermlingType type) {
        if (type == EnumGermlingType.POLLEN) {
            return this.pollenModel;
        }
        if (type == EnumGermlingType.CHARCOAL) {
            return this.charcoalModel;
        }
        return this.germlingModel;
    }
}

