/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.core.IModelBaker;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.models.ModelBlockDefault;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelLeaves
extends ModelBlockDefault<BlockForestryLeaves> {
    public ModelLeaves() {
        super(BlockForestryLeaves.class);
    }

    @Override
    public void bakeInventoryBlock(@Nonnull BlockForestryLeaves block, @Nonnull ItemStack itemStack, @Nonnull IModelBaker baker) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockLeaves) || block == null) {
            return;
        }
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        TileLeaves leaves = new TileLeaves();
        if (itemStack.func_77942_o()) {
            leaves.func_145839_a(itemStack.func_77978_p());
        } else {
            leaves.setTree(TreeRoot.treeTemplates.get(0));
        }
        ResourceLocation leafSpriteLocation = leaves.getLeaveSprite(Proxies.render.fancyGraphicsEnabled());
        TextureAtlasSprite leavesIcon = map.func_110572_b(leafSpriteLocation.toString());
        if (leavesIcon == null) {
            return;
        }
        baker.addBlockModel((Block)block, Block.field_185505_j, null, leavesIcon, 0);
        if (!leaves.hasFruit()) {
            return;
        }
        ResourceLocation fruitSpriteLocation = leaves.getFruitSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitTexture = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel((Block)block, Block.field_185505_j, null, fruitTexture, 1);
        }
    }

    @Override
    public void bakeWorldBlock(@Nonnull BlockForestryLeaves block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IExtendedBlockState stateExtended, @Nonnull IModelBaker baker) {
        TileLeaves tile = TileUtil.getTile(world, pos, TileLeaves.class);
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        if (tile == null) {
            IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.getIndividual().getGenome().getPrimary();
            ResourceLocation spriteLocation = oakSpecies.getLeafSpriteProvider().getSprite(false, Proxies.render.fancyGraphicsEnabled());
            TextureAtlasSprite sprite = map.func_110572_b(spriteLocation.toString());
            baker.setParticleSprite(sprite);
            return;
        }
        ResourceLocation leafSpriteLocation = tile.getLeaveSprite(Proxies.render.fancyGraphicsEnabled());
        TextureAtlasSprite leafSprite = map.func_110572_b(leafSpriteLocation.toString());
        baker.addBlockModel((Block)block, Block.field_185505_j, pos, leafSprite, 0);
        ResourceLocation fruitSpriteLocation = tile.getFruitSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, fruitSprite, 1);
        }
        baker.setParticleSprite(leafSprite);
    }
}

