/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.PluginCore;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.GeneticsUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource,
IHintSource {
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_SPECIMEN = 1;
    public static final int SLOT_ANALYZE_1 = 2;
    public static final int SLOT_ANALYZE_2 = 3;
    public static final int SLOT_ANALYZE_3 = 4;
    public static final int SLOT_ANALYZE_4 = 5;
    public static final int SLOT_ANALYZE_5 = 6;

    public ItemInventoryAlyzer(EntityPlayer player, ItemStack itemstack) {
        super(player, 7, itemstack);
    }

    public static boolean isAlyzingFuel(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        return beeItems.honeyDrop == item || beeItems.honeydew == item;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return ItemInventoryAlyzer.isAlyzingFuel(itemStack);
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack));
        if (speciesRoot == null) {
            return false;
        }
        if (this.hasSpecimen() && this.func_70301_a(slotIndex) == null) {
            return false;
        }
        if (slotIndex == 1) {
            return true;
        }
        IIndividual individual = speciesRoot.getMember(itemStack);
        return individual.isAnalyzed();
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        ItemStack ersatz;
        if (!this.hasSpecimen() && slotIndex == 1 && (ersatz = GeneticsUtil.convertToGeneticEquivalent(itemStack)) != null) {
            super.func_70299_a(slotIndex, ersatz);
            return;
        }
        super.func_70299_a(slotIndex, itemStack);
    }

    @Override
    public void onSlotClick(int slotIndex, EntityPlayer player) {
        ISpeciesRoot speciesRoot;
        ItemStack specimen = this.func_70301_a(1);
        if (specimen == null) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            this.func_70299_a(1, convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) == null) {
            return;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (!individual.isAnalyzed()) {
            if (ForestryAPI.enabledPlugins.contains("forestry.apiculture") && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                return;
            }
            individual.analyze();
            if (player != null) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            individual.writeToNBT(nbttagcompound);
            specimen.func_77982_d(nbttagcompound);
            this.func_70298_a(0, 1);
        }
        this.func_70299_a(2, specimen);
        this.func_70299_a(1, null);
        PluginCore.items.portableAlyzer.openGui(player);
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.hasSpecimen()) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        } else {
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen());
            if (speciesRoot != null && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                errorStates.add((Object)EnumErrorCode.NO_HONEY);
            }
        }
        return errorStates.build();
    }

    public ItemStack getSpecimen() {
        for (int i = 1; i <= 6; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    public boolean hasSpecimen() {
        return this.getSpecimen() != null;
    }

    @Override
    public List<String> getHints() {
        IAlyzerPlugin alyzerPlugin;
        ISpeciesRoot speciesRoot;
        ItemStack specimen = this.getSpecimen();
        if (specimen != null && (speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) != null && (alyzerPlugin = speciesRoot.getAlyzerPlugin()) != null) {
            return alyzerPlugin.getHints();
        }
        return Collections.emptyList();
    }
}

