/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MultiblockWorldRegistry {
    private World worldObj;
    private final Set<IMultiblockControllerInternal> controllers;
    private final Set<IMultiblockControllerInternal> dirtyControllers;
    private final Set<IMultiblockControllerInternal> deadControllers;
    private Set<IMultiblockComponent> orphanedParts;
    private final Set<IMultiblockComponent> detachedParts;
    private final HashMap<Long, Set<IMultiblockComponent>> partsAwaitingChunkLoad;
    private final Object partsAwaitingChunkLoadMutex;
    private final Object orphanedPartsMutex;

    public MultiblockWorldRegistry(World world) {
        this.worldObj = world;
        this.controllers = new HashSet<IMultiblockControllerInternal>();
        this.deadControllers = new HashSet<IMultiblockControllerInternal>();
        this.dirtyControllers = new HashSet<IMultiblockControllerInternal>();
        this.detachedParts = new HashSet<IMultiblockComponent>();
        this.orphanedParts = new HashSet<IMultiblockComponent>();
        this.partsAwaitingChunkLoad = new HashMap();
        this.partsAwaitingChunkLoadMutex = new Object();
        this.orphanedPartsMutex = new Object();
    }

    public void tickStart() {
        if (!this.controllers.isEmpty()) {
            for (IMultiblockControllerInternal controller : this.controllers) {
                if (controller.getWorldObj() != this.worldObj || controller.getWorldObj().field_72995_K != this.worldObj.field_72995_K) continue;
                if (controller.isEmpty()) {
                    this.deadControllers.add(controller);
                    continue;
                }
                controller.updateMultiblockEntity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMultiblockChanges() {
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        ArrayList<Set<IMultiblockControllerInternal>> mergePools = null;
        if (!this.orphanedParts.isEmpty()) {
            Set<IMultiblockComponent> orphansToProcess = null;
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                if (!this.orphanedParts.isEmpty()) {
                    orphansToProcess = this.orphanedParts;
                    this.orphanedParts = new HashSet<IMultiblockComponent>();
                }
            }
            if (orphansToProcess != null && !orphansToProcess.isEmpty()) {
                for (IMultiblockComponent orphan : orphansToProcess) {
                    BlockPos coord = orphan.getCoordinates();
                    if (chunkProvider.func_186026_b(coord.func_177958_n() >> 4, coord.func_177952_p() >> 4) == null || orphan instanceof TileEntity && ((TileEntity)orphan).func_145837_r() || this.worldObj.func_175625_s(coord) != orphan) continue;
                    Set<IMultiblockControllerInternal> set = this.attachToNeighbors(orphan);
                    if (set.isEmpty()) {
                        MultiblockLogic logic = (MultiblockLogic)orphan.getMultiblockLogic();
                        Object newController = logic.createNewController(this.worldObj);
                        newController.attachBlock(orphan);
                        this.controllers.add((IMultiblockControllerInternal)newController);
                        continue;
                    }
                    if (set.size() <= 1) continue;
                    if (mergePools == null) {
                        mergePools = new ArrayList<Set<IMultiblockControllerInternal>>();
                    }
                    ArrayList<Set> candidatePools = new ArrayList<Set>();
                    for (Set set2 : mergePools) {
                        if (Collections.disjoint(set2, set)) continue;
                        candidatePools.add(set2);
                    }
                    if (candidatePools.size() <= 0) {
                        mergePools.add(set);
                        continue;
                    }
                    if (candidatePools.size() == 1) {
                        ((Set)candidatePools.get(0)).addAll(set);
                        continue;
                    }
                    Set masterPool = (Set)candidatePools.get(0);
                    for (int i = 1; i < candidatePools.size(); ++i) {
                        Set set3 = (Set)candidatePools.get(i);
                        masterPool.addAll(set3);
                        mergePools.remove(set3);
                    }
                    masterPool.addAll(set);
                }
            }
        }
        if (mergePools != null && !mergePools.isEmpty()) {
            for (Set set : mergePools) {
                IMultiblockControllerInternal newMaster = null;
                for (IMultiblockControllerInternal controller : set) {
                    if (newMaster != null && !controller.shouldConsume(newMaster)) continue;
                    newMaster = controller;
                }
                if (newMaster == null) {
                    Log.error("Multiblock system checked a merge pool of size %d, found no master candidates. This should never happen.", set.size());
                    continue;
                }
                this.addDirtyController(newMaster);
                for (IMultiblockControllerInternal controller : set) {
                    if (controller == newMaster) continue;
                    newMaster.assimilate(controller);
                    this.addDeadController(controller);
                    this.addDirtyController(newMaster);
                }
            }
        }
        if (!this.dirtyControllers.isEmpty()) {
            for (IMultiblockControllerInternal iMultiblockControllerInternal : this.dirtyControllers) {
                if (iMultiblockControllerInternal == null) continue;
                Set<IMultiblockComponent> newlyDetachedParts = iMultiblockControllerInternal.checkForDisconnections();
                if (!iMultiblockControllerInternal.isEmpty()) {
                    iMultiblockControllerInternal.recalculateMinMaxCoords();
                    iMultiblockControllerInternal.checkIfMachineIsWhole();
                } else {
                    this.addDeadController(iMultiblockControllerInternal);
                }
                if (newlyDetachedParts.isEmpty()) continue;
                this.detachedParts.addAll(newlyDetachedParts);
            }
            this.dirtyControllers.clear();
        }
        if (!this.deadControllers.isEmpty()) {
            for (IMultiblockControllerInternal iMultiblockControllerInternal : this.deadControllers) {
                if (!iMultiblockControllerInternal.isEmpty()) {
                    Log.error("Found a non-empty controller. Forcing it to shed its blocks and die. This should never happen!", new Object[0]);
                    this.detachedParts.addAll(iMultiblockControllerInternal.detachAllBlocks());
                }
                this.controllers.remove(iMultiblockControllerInternal);
            }
            this.deadControllers.clear();
        }
        for (IMultiblockComponent iMultiblockComponent : this.detachedParts) {
            MultiblockLogic logic = (MultiblockLogic)iMultiblockComponent.getMultiblockLogic();
            logic.assertDetached(iMultiblockComponent);
        }
        this.addAllOrphanedPartsThreadsafe(this.detachedParts);
        this.detachedParts.clear();
    }

    private Set<IMultiblockControllerInternal> attachToNeighbors(IMultiblockComponent part) {
        HashSet<IMultiblockControllerInternal> controllers = new HashSet<IMultiblockControllerInternal>();
        IMultiblockControllerInternal bestController = null;
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        Class controllerClass = logic.getControllerClass();
        List<IMultiblockComponent> partsToCheck = MultiblockUtil.getNeighboringParts(this.worldObj, part);
        for (IMultiblockComponent neighborPart : partsToCheck) {
            IMultiblockControllerInternal candidate;
            IMultiblockLogic neighborLogic = neighborPart.getMultiblockLogic();
            if (!neighborLogic.isConnected() || !controllerClass.isAssignableFrom((candidate = (IMultiblockControllerInternal)neighborLogic.getController()).getClass())) continue;
            if (!controllers.contains(candidate) && (bestController == null || candidate.shouldConsume(bestController))) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            bestController.attachBlock(part);
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartAdded(IMultiblockComponent part) {
        BlockPos worldLocation = part.getCoordinates();
        if (this.worldObj.func_72863_F().func_186026_b(worldLocation.func_177958_n() >> 4, worldLocation.func_177952_p() >> 4) == null) {
            long chunkHash = ChunkCoordIntPair.func_77272_a((int)(worldLocation.func_177958_n() >> 4), (int)(worldLocation.func_177952_p() >> 4));
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                Set<Object> partSet;
                if (!this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    partSet = new HashSet();
                    this.partsAwaitingChunkLoad.put(chunkHash, partSet);
                } else {
                    partSet = this.partsAwaitingChunkLoad.get(chunkHash);
                }
                partSet.add(part);
            }
        } else {
            this.addOrphanedPartThreadsafe(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartRemovedFromWorld(IMultiblockComponent part) {
        long hash2;
        BlockPos coord = part.getCoordinates();
        if (coord != null && this.partsAwaitingChunkLoad.containsKey(hash2 = ChunkCoordIntPair.func_77272_a((int)(coord.func_177958_n() >> 4), (int)(coord.func_177952_p() >> 4)))) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(hash2)) {
                    this.partsAwaitingChunkLoad.get(hash2).remove(part);
                    if (this.partsAwaitingChunkLoad.get(hash2).size() <= 0) {
                        this.partsAwaitingChunkLoad.remove(hash2);
                    }
                }
            }
        }
        this.detachedParts.remove(part);
        if (this.orphanedParts.contains(part)) {
            Object hash2 = this.orphanedPartsMutex;
            synchronized (hash2) {
                this.orphanedParts.remove(part);
            }
        }
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.assertDetached(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnloaded() {
        this.controllers.clear();
        this.deadControllers.clear();
        this.dirtyControllers.clear();
        this.detachedParts.clear();
        Object object = this.partsAwaitingChunkLoadMutex;
        synchronized (object) {
            this.partsAwaitingChunkLoad.clear();
        }
        object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.clear();
        }
        this.worldObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoaded(int chunkX, int chunkZ) {
        long chunkHash = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
        if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    this.addAllOrphanedPartsThreadsafe((Collection<? extends IMultiblockComponent>)this.partsAwaitingChunkLoad.get(chunkHash));
                    this.partsAwaitingChunkLoad.remove(chunkHash);
                }
            }
        }
    }

    public void addDeadController(IMultiblockControllerInternal deadController) {
        this.deadControllers.add(deadController);
    }

    public void addDirtyController(IMultiblockControllerInternal dirtyController) {
        this.dirtyControllers.add(dirtyController);
    }

    public Set<IMultiblockControllerInternal> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphanedPartThreadsafe(IMultiblockComponent part) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllOrphanedPartsThreadsafe(Collection<? extends IMultiblockComponent> parts) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.addAll(parts);
        }
    }
}

