/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.blocks.BlockTreeContainer;
import forestry.arboriculture.blocks.property.PropertyTree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.render.SaplingStateMapper;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSapling
extends BlockTreeContainer
implements IGrowable,
IStateMapperRegister,
IItemModelRegister {
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    public static final PropertyTree TREE = new PropertyTree("tree");

    public static TileSapling getSaplingTile(IBlockAccess world, BlockPos pos) {
        return TileUtil.getTile(world, pos, TileSapling.class);
    }

    public BlockSapling() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return new TileSapling();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileSapling sapling = BlockSapling.getSaplingTile(world, pos);
        state = sapling != null && sapling.getTree() != null ? state.func_177226_a((IProperty)TREE, (Comparable)sapling.getTree().getGenome().getPrimary()) : state.func_177226_a((IProperty)TREE, (Comparable)TreeDefinition.Oak.getGenome().getPrimary());
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TREE});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, new SaplingStateMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "germlings/sapling.treeLarch");
    }

    public static boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        TileSapling tile = BlockSapling.getSaplingTile(world, pos);
        if (tile == null) {
            return false;
        }
        ITree tree = tile.getTree();
        if (tree == null) {
            return false;
        }
        return tree.canStay(world, pos);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(world, pos, state, neighborBlock);
        if (!world.field_72995_K && !BlockSapling.canBlockStay((IBlockAccess)world, pos)) {
            BlockSapling.dropAsSapling(world, pos);
            world.func_175698_g(pos);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileSapling sapling = BlockSapling.getSaplingTile((IBlockAccess)world, pos);
        if (sapling == null || sapling.getTree() == null) {
            return null;
        }
        return TreeManager.treeRoot.getMemberStack(sapling.getTree(), EnumGermlingType.SAPLING);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K && this.canHarvestBlock((IBlockAccess)world, pos, player) && !player.field_71075_bZ.field_75098_d) {
            BlockSapling.dropAsSapling(world, pos);
        }
        return world.func_175698_g(pos);
    }

    private static void dropAsSapling(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileSapling sapling = BlockSapling.getSaplingTile((IBlockAccess)world, pos);
        if (sapling != null && sapling.getTree() != null) {
            ItemStack saplingStack = TreeManager.treeRoot.getMemberStack(sapling.getTree(), EnumGermlingType.SAPLING);
            ItemStackUtil.dropItemStackAsEntity(saplingStack, world, pos);
        }
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        if (world.field_73012_v.nextFloat() >= 0.45f) {
            return false;
        }
        TileSapling saplingTile = BlockSapling.getSaplingTile((IBlockAccess)world, pos);
        if (saplingTile != null) {
            return saplingTile.canAcceptBoneMeal(rand);
        }
        return true;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileSapling saplingTile = BlockSapling.getSaplingTile((IBlockAccess)world, pos);
        if (saplingTile != null) {
            saplingTile.tryGrow(rand, true);
        }
    }
}

