/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.core.EnumCamouflageType;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.greenhouse.GreenhouseEvents;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ITitled;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.GuiGreenhouse;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.network.packets.PacketCamouflageUpdate;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileGreenhouse
extends MultiblockTileEntityForestry<MultiblockLogicGreenhouse>
implements IGreenhouseComponent,
IHintSource,
IStreamableGui,
IErrorLogicSource,
IRestrictedAccess,
ITitled,
ICamouflageHandler,
ICamouflagedTile {
    private ItemStack camouflageBlock = null;

    protected TileGreenhouse() {
        super(new MultiblockLogicGreenhouse());
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        this.func_70296_d();
    }

    @Override
    public void onMachineBroken() {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("CamouflageBlock")) {
            this.camouflageBlock = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("CamouflageBlock"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.camouflageBlock != null) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
    }

    @Override
    public void setCamouflageBlock(EnumCamouflageType type, ItemStack camouflageBlock) {
        this.camouflageBlock = camouflageBlock;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            Proxies.net.sendToServer(new PacketCamouflageUpdate(this, type));
        }
        MinecraftForge.EVENT_BUS.post((Event)new GreenhouseEvents.CamouflageChangeEvent(((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().createState(), this, this, type));
    }

    @Override
    public ItemStack getCamouflageBlock(EnumCamouflageType type) {
        return this.camouflageBlock;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(EnumCamouflageType type) {
        return null;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        if (this.camouflageBlock != null) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            packetData.func_74782_a("CamouflageBlock", (NBTBase)nbtTag);
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("CamouflageBlock")) {
            this.setCamouflageBlock(this.getCamouflageType(), ItemStack.func_77949_a((NBTTagCompound)packetData.func_74775_l("CamouflageBlock")));
        }
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"greenhouse");
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().writeGuiData(data);
        ItemStack camouflageBlock = this.getCamouflageBlock(this.getCamouflageType());
        if (camouflageBlock != null) {
            data.writeShort(1);
            data.writeItemStack(camouflageBlock);
        } else {
            data.writeShort(0);
        }
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().readGuiData(data);
        if (data.readShort() == 1) {
            this.setCamouflageBlock(this.getCamouflageType(), data.readItemStack());
        }
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().onSwitchAccess(oldAccess, newAccess);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.greenhouse.title";
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiGreenhouse(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerGreenhouse(player.field_71071_by, this);
    }

    @Override
    public EnumCamouflageType getCamouflageType() {
        if (this.func_145838_q() instanceof BlockGreenhouse && ((BlockGreenhouse)this.func_145838_q()).getGreenhouseType() == BlockGreenhouseType.GLASS) {
            return EnumCamouflageType.GLASS;
        }
        return EnumCamouflageType.DEFAULT;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getInternalInventory();
    }
}

