/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.gui.GuiBottler;
import forestry.factory.inventory.InventoryBottler;
import forestry.factory.recipes.BottlerRecipe;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private static final int TICKS_PER_RECIPE_TIME = 5;
    private static final int ENERGY_PER_RECIPE_TIME = 1000;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private BottlerRecipe currentRecipe;

    public TileBottler() {
        super("bottler", 1100, 4000);
        this.setInternalInventory(new InventoryBottler(this));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
        }
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid());
        return status == FluidHelper.FillStatus.SUCCESS;
    }

    private void checkRecipe() {
        ItemStack emptyCan = this.func_70301_a(0);
        FluidStack resource = this.resourceTank.getFluid();
        if (this.currentRecipe == null || !this.currentRecipe.matches(emptyCan, resource)) {
            this.currentRecipe = BottlerRecipe.getRecipe(resource, emptyCan);
            if (this.currentRecipe != null) {
                float viscosityMultiplier = (float)resource.getFluid().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.input.amount, resource.amount);
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                this.setEnergyPerWorkCycle(Math.round(fillTime * 1000.0f));
            }
        }
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)inventory.func_70301_a((int)0).field_77994_a / (float)inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        IErrorLogic errorLogic = this.getErrorLogic();
        FluidHelper.FillStatus status = this.currentRecipe == null ? FluidHelper.FillStatus.NO_FLUID : FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid(), false);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_FLUID, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_SPACE, EnumErrorCode.NO_SPACE_INVENTORY);
        return status == FluidHelper.FillStatus.SUCCESS;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiBottler(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerBottler(player.field_71071_by, this);
    }
}

