/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumPileType;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.render.ParticleHelper;
import forestry.core.render.TextureManager;
import forestry.core.tiles.TileUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PileParticleCallback
extends ParticleHelper.DefaultCallback<BlockPile> {
    public PileParticleCallback(BlockPile block) {
        super(block);
    }

    @Override
    protected void setTexture(EntityDiggingFX fx, World world, BlockPos pos, IBlockState state) {
        EnumPileType type = ((BlockPile)this.block).getPileType();
        TilePile pile = TileUtil.getTile((IBlockAccess)world, pos, TilePile.class);
        if (pile == null || pile.getTree() == null) {
            super.setTexture(fx, world, pos, state);
            return;
        }
        TextureAtlasSprite texture = type == EnumPileType.DIRT ? TextureManager.registerSprite(new ResourceLocation("forestry:blocks/loam")) : (type == EnumPileType.WOOD ? pile.getTree().getGenome().getPrimary().getWoodProvider().getSprite(false) : TextureManager.registerSprite(new ResourceLocation("forestry:blocks/ash")));
        fx.func_187117_a(texture);
    }
}

