/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.arboriculture.blocks.BlockArbDoor;
import forestry.arboriculture.blocks.BlockArbFence;
import forestry.arboriculture.blocks.BlockArbFenceGate;
import forestry.arboriculture.blocks.BlockArbLog;
import forestry.arboriculture.blocks.BlockArbPlanks;
import forestry.arboriculture.blocks.BlockArbSlab;
import forestry.arboriculture.blocks.BlockArbStairs;
import forestry.arboriculture.blocks.BlockArboriculture;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.blocks.BlockTypeArboricultureTesr;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.items.ItemBlockDecorativeLeaves;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.items.ItemBlockPile;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.items.ItemBlockWoodDoor;
import forestry.arboriculture.items.ItemBlockWoodSlab;
import forestry.core.blocks.BlockRegistry;
import forestry.core.items.ItemBlockForestry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BlockRegistryArboriculture
extends BlockRegistry {
    public final List<BlockArbLog> logs = BlockArbLog.create(false);
    public final List<BlockArbLog> logsFireproof;
    public final List<BlockArbPlanks> planks;
    public final List<BlockArbPlanks> planksFireproof;
    public final List<BlockArbSlab> slabs;
    public final List<BlockArbSlab> slabsDouble;
    public final List<BlockArbSlab> slabsFireproof;
    public final List<BlockArbSlab> slabsDoubleFireproof;
    public final List<BlockArbFence> fences;
    public final List<BlockArbFence> fencesFireproof;
    public final List<BlockArbFenceGate> fenceGates;
    public final List<BlockArbFenceGate> fenceGatesFireproof;
    public final List<BlockArbStairs> stairs;
    public final List<BlockArbStairs> stairsFireproof;
    public final List<BlockArbDoor> doors;
    public final BlockSapling saplingGE;
    public final BlockForestryLeaves leaves;
    public final List<BlockDecorativeLeaves> leavesDecorative;
    private final Map<String, ItemStack> speciesToLeavesDecorative;
    public final Map<String, BlockFruitPod> podsMap;
    public final Map<EnumPileType, BlockPile> piles;
    public final BlockArboriculture treeChest;

    public BlockRegistryArboriculture() {
        BlockArbStairs stair;
        EnumWoodType woodType;
        BlockArbSlab slabDouble;
        int i;
        for (BlockArbLog blockArbLog : this.logs) {
            this.registerBlock(blockArbLog, new ItemBlockWood((Block)blockArbLog), "logs." + blockArbLog.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("logWood", (Block)blockArbLog);
        }
        this.logsFireproof = BlockArbLog.create(true);
        for (BlockArbLog blockArbLog : this.logsFireproof) {
            this.registerBlock(blockArbLog, new ItemBlockWood((Block)blockArbLog), "logs.fireproof." + blockArbLog.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("logWood", (Block)blockArbLog);
        }
        this.planks = BlockArbPlanks.create(false);
        for (BlockArbPlanks blockArbPlanks : this.planks) {
            this.registerBlock(blockArbPlanks, new ItemBlockWood(blockArbPlanks), "planks." + blockArbPlanks.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("plankWood", blockArbPlanks);
        }
        this.planksFireproof = BlockArbPlanks.create(true);
        for (BlockArbPlanks blockArbPlanks : this.planksFireproof) {
            this.registerBlock(blockArbPlanks, new ItemBlockWood(blockArbPlanks), "planks.fireproof." + blockArbPlanks.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("plankWood", blockArbPlanks);
        }
        this.slabs = BlockArbSlab.create(false, false);
        this.slabsDouble = BlockArbSlab.create(false, true);
        for (i = 0; i < this.slabs.size(); ++i) {
            BlockArbSlab blockArbSlab = this.slabs.get(i);
            slabDouble = this.slabsDouble.get(i);
            this.registerBlock(blockArbSlab, (ItemBlock)new ItemBlockWoodSlab(blockArbSlab, blockArbSlab, slabDouble), "slabs." + blockArbSlab.getBlockNumber());
            this.registerBlock(slabDouble, (ItemBlock)new ItemBlockWoodSlab(slabDouble, blockArbSlab, slabDouble), "slabs.double." + slabDouble.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("slabWood", (Block)blockArbSlab);
        }
        this.slabsFireproof = BlockArbSlab.create(true, false);
        this.slabsDoubleFireproof = BlockArbSlab.create(true, true);
        for (i = 0; i < this.slabsFireproof.size(); ++i) {
            BlockArbSlab blockArbSlab = this.slabsFireproof.get(i);
            slabDouble = this.slabsDoubleFireproof.get(i);
            this.registerBlock(blockArbSlab, (ItemBlock)new ItemBlockWoodSlab(blockArbSlab, blockArbSlab, slabDouble), "slabs.fireproof." + blockArbSlab.getBlockNumber());
            this.registerBlock(slabDouble, (ItemBlock)new ItemBlockWoodSlab(slabDouble, blockArbSlab, slabDouble), "slabs.double.fireproof." + slabDouble.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("slabWood", (Block)blockArbSlab);
        }
        this.fences = BlockArbFence.create(false);
        for (BlockArbFence blockArbFence : this.fences) {
            this.registerBlock(blockArbFence, new ItemBlockWood((Block)blockArbFence), "fences." + blockArbFence.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("fenceWood", (Block)blockArbFence);
        }
        this.fencesFireproof = BlockArbFence.create(true);
        for (BlockArbFence blockArbFence : this.fencesFireproof) {
            this.registerBlock(blockArbFence, new ItemBlockWood((Block)blockArbFence), "fences.fireproof." + blockArbFence.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("fenceWood", (Block)blockArbFence);
        }
        this.fenceGates = new ArrayList<BlockArbFenceGate>();
        this.fenceGatesFireproof = new ArrayList<BlockArbFenceGate>();
        for (EnumWoodType woodType2 : EnumWoodType.VALUES) {
            BlockArbFenceGate fenceGate = new BlockArbFenceGate(false, woodType2);
            this.registerBlock(fenceGate, new ItemBlockWood((Block)fenceGate), "fence.gates." + (Object)((Object)woodType2));
            BlockRegistryArboriculture.registerOreDictWildcard("fenceGateWood", (Block)fenceGate);
            this.fenceGates.add(fenceGate);
            BlockArbFenceGate fenceGateFireproof = new BlockArbFenceGate(true, woodType2);
            this.registerBlock(fenceGateFireproof, new ItemBlockWood((Block)fenceGateFireproof), "fence.gates.fireproof." + (Object)((Object)woodType2));
            BlockRegistryArboriculture.registerOreDictWildcard("fenceGateWood", (Block)fenceGateFireproof);
            this.fenceGatesFireproof.add(fenceGateFireproof);
        }
        this.stairs = new ArrayList<BlockArbStairs>();
        for (BlockArbPlanks blockArbPlanks : this.planks) {
            for (IBlockState blockState : blockArbPlanks.func_176194_O().func_177619_a()) {
                int meta = blockArbPlanks.func_176201_c(blockState);
                woodType = blockArbPlanks.getWoodType(meta);
                stair = new BlockArbStairs(false, blockState, woodType);
                this.registerBlock(stair, new ItemBlockWood((Block)stair), "stairs." + (Object)((Object)woodType));
                BlockRegistryArboriculture.registerOreDictWildcard("stairWood", (Block)stair);
                this.stairs.add(stair);
            }
        }
        this.stairsFireproof = new ArrayList<BlockArbStairs>();
        for (BlockArbPlanks blockArbPlanks : this.planksFireproof) {
            for (IBlockState blockState : blockArbPlanks.func_176194_O().func_177619_a()) {
                int meta = blockArbPlanks.func_176201_c(blockState);
                woodType = blockArbPlanks.getWoodType(meta);
                stair = new BlockArbStairs(true, blockState, woodType);
                this.registerBlock(stair, new ItemBlockWood((Block)stair), "stairs.fireproof." + (Object)((Object)woodType));
                BlockRegistryArboriculture.registerOreDictWildcard("stairWood", (Block)stair);
                this.stairsFireproof.add(stair);
            }
        }
        this.doors = new ArrayList<BlockArbDoor>();
        for (EnumWoodType woodType2 : EnumWoodType.VALUES) {
            BlockArbDoor door = new BlockArbDoor(woodType2);
            this.registerBlock(door, new ItemBlockWoodDoor((Block)door), "doors." + woodType2);
            BlockRegistryArboriculture.registerOreDictWildcard("doorWood", (Block)door);
            this.doors.add(door);
        }
        TreeDefinition.preInit();
        this.saplingGE = new BlockSapling();
        this.registerBlock(this.saplingGE, new ItemBlockForestry((Block)this.saplingGE), "saplingGE");
        BlockRegistryArboriculture.registerOreDictWildcard("treeSapling", (Block)this.saplingGE);
        this.leaves = new BlockForestryLeaves();
        this.registerBlock(this.leaves, new ItemBlockLeaves((Block)this.leaves), "leaves");
        BlockRegistryArboriculture.registerOreDictWildcard("treeLeaves", (Block)this.leaves);
        this.leavesDecorative = BlockDecorativeLeaves.create();
        this.speciesToLeavesDecorative = new HashMap<String, ItemStack>();
        for (BlockDecorativeLeaves blockDecorativeLeaves : this.leavesDecorative) {
            this.registerBlock(blockDecorativeLeaves, new ItemBlockDecorativeLeaves(blockDecorativeLeaves), "leaves.decorative." + blockDecorativeLeaves.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("treeLeaves", blockDecorativeLeaves);
            for (IBlockState state : blockDecorativeLeaves.func_176194_O().func_177619_a()) {
                TreeDefinition treeDefinition = (TreeDefinition)((Object)state.func_177229_b((IProperty)blockDecorativeLeaves.getVariant()));
                String speciesUid = treeDefinition.getUID();
                int meta = blockDecorativeLeaves.func_176201_c(state);
                this.speciesToLeavesDecorative.put(speciesUid, new ItemStack((Block)blockDecorativeLeaves, 1, meta));
            }
        }
        this.piles = BlockPile.create();
        for (Map.Entry entry : this.piles.entrySet()) {
            this.registerBlock((Block)entry.getValue(), new ItemBlockPile((Block)entry.getValue()), "pile_" + ((EnumPileType)((Object)entry.getKey())).name().toLowerCase(Locale.ENGLISH));
        }
        AlleleFruit.createAlleles();
        this.podsMap = new HashMap<String, BlockFruitPod>();
        for (BlockFruitPod blockFruitPod : BlockFruitPod.create()) {
            IAlleleFruit fruit = blockFruitPod.getFruit();
            this.registerBlock(blockFruitPod, "pods." + fruit.getModelName());
            this.podsMap.put(fruit.getUID(), blockFruitPod);
        }
        this.treeChest = new BlockArboriculture(BlockTypeArboricultureTesr.ARB_CHEST);
        this.registerBlock(this.treeChest, new ItemBlockForestry(this.treeChest), "tree_chest");
    }

    public ItemStack getDecorativeLeaves(String speciesUid) {
        ItemStack itemStack = this.speciesToLeavesDecorative.get(speciesUid);
        if (itemStack == null) {
            return null;
        }
        return itemStack.func_77946_l();
    }

    public BlockFruitPod getFruitPod(IAlleleFruit fruit) {
        return this.podsMap.get(fruit.getUID());
    }
}

