/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.farming.FarmDirection;
import forestry.farming.FarmHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmTarget {
    private final BlockPos start;
    private final FarmDirection direction;
    private final int limit;
    private int yOffset;
    private int extent;

    public FarmTarget(BlockPos start, FarmDirection direction, int limit) {
        this.start = start;
        this.direction = direction;
        this.limit = limit;
    }

    public BlockPos getStart() {
        return this.start;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getExtent() {
        return this.extent;
    }

    public FarmDirection getDirection() {
        return this.direction;
    }

    public void setExtentAndYOffset(World world, BlockPos platformPosition) {
        IBlockState blockState;
        if (platformPosition == null) {
            this.extent = 0;
            return;
        }
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(platformPosition);
        this.extent = 0;
        while (this.extent < this.limit && FarmHelper.bricks.contains((Object)(blockState = world.func_180495_p((BlockPos)position)).func_177230_c())) {
            position.func_185337_c(this.getDirection().getFacing());
            ++this.extent;
        }
        this.yOffset = platformPosition.func_177956_o() + 1 - this.getStart().func_177956_o();
    }
}

