/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ITextureManager;
import forestry.core.render.ForestryResource;
import forestry.core.render.TextureManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WoodProvider
implements IWoodProvider {
    private final String name;
    private final EnumWoodType woodType;
    private TextureAtlasSprite woodTop;
    private TextureAtlasSprite woodBark;

    public WoodProvider(String name, EnumWoodType woodType) {
        this.name = name;
        this.woodType = woodType;
    }

    @Override
    public void registerSprites(Item item, ITextureManager manager) {
        this.woodTop = TextureManager.registerSprite(new ForestryResource("blocks/wood/heart." + this.name));
        this.woodBark = TextureManager.registerSprite(new ForestryResource("blocks/wood/bark." + this.name));
    }

    @Override
    public TextureAtlasSprite getSprite(boolean isTop) {
        if (isTop) {
            return this.woodTop;
        }
        return this.woodBark;
    }

    @Override
    public ItemStack getWoodStack() {
        return TreeManager.woodAccess.getLog(this.woodType, false);
    }
}

