/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeeSpriteColourProvider;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.IModelManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.DefaultBeeModelProvider;
import forestry.apiculture.genetics.DefaultBeeSpriteColourProvider;
import forestry.apiculture.genetics.JubilanceDefault;
import forestry.core.genetics.alleles.AlleleSpecies;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleBeeSpecies
extends AlleleSpecies
implements IAlleleBeeSpecies,
IAlleleBeeSpeciesBuilder {
    private final Map<ItemStack, Float> productChances = new HashMap<ItemStack, Float>();
    private final Map<ItemStack, Float> specialtyChances = new HashMap<ItemStack, Float>();
    private IBeeModelProvider beeModelProvider = DefaultBeeModelProvider.instance;
    private IBeeSpriteColourProvider beeSpriteColourProvider;
    private IJubilanceProvider jubilanceProvider;
    private boolean nocturnal = false;

    public AlleleBeeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean dominant, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, dominant, branch, binomial);
        this.beeSpriteColourProvider = new DefaultBeeSpriteColourProvider(primaryColor, secondaryColor);
        this.jubilanceProvider = JubilanceDefault.instance;
    }

    @Override
    public IAlleleBeeSpecies build() {
        AlleleManager.alleleRegistry.registerAllele(this, EnumBeeChromosome.SPECIES);
        return this;
    }

    @Override
    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    @Override
    public IAlleleBeeSpeciesBuilder addProduct(ItemStack product, Float chance) {
        if (product == null || product.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to add null product");
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            throw new IllegalArgumentException("chance must be in the range (0, 1]");
        }
        this.productChances.put(product, chance);
        return this;
    }

    @Override
    public IAlleleBeeSpeciesBuilder addSpecialty(ItemStack specialty, Float chance) {
        if (specialty == null || specialty.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to add null specialty");
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            throw new IllegalArgumentException("chance must be in the range (0, 1]");
        }
        this.specialtyChances.put(specialty, chance);
        return this;
    }

    @Override
    public IAlleleBeeSpeciesBuilder setJubilanceProvider(IJubilanceProvider provider) {
        this.jubilanceProvider = provider;
        return this;
    }

    @Override
    public IAlleleBeeSpeciesBuilder setNocturnal() {
        this.nocturnal = true;
        return this;
    }

    @Override
    public IAlleleBeeSpeciesBuilder setCustomBeeModelProvider(IBeeModelProvider beeIconProvider) {
        this.beeModelProvider = beeIconProvider;
        return this;
    }

    @Override
    public IAlleleBeeSpeciesBuilder setCustomBeeSpriteColourProvider(IBeeSpriteColourProvider beeIconColourProvider) {
        this.beeSpriteColourProvider = beeIconColourProvider;
        return this;
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        for (ItemStack stack : this.productChances.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.specialtyChances.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        Collections.addAll(bounty, super.getResearchBounty(world, researcher, individual, bountyLevel));
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialtyChances.keySet()) {
                bounty.add(ItemStackUtil.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
            }
        }
        for (ItemStack stack : this.productChances.keySet()) {
            bounty.add(ItemStackUtil.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
        }
        return bounty.toArray(new ItemStack[bounty.size()]);
    }

    @Override
    public boolean isNocturnal() {
        return this.nocturnal;
    }

    @Override
    public Map<ItemStack, Float> getProductChances() {
        return this.productChances;
    }

    @Override
    public Map<ItemStack, Float> getSpecialtyChances() {
        return this.specialtyChances;
    }

    @Override
    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return this.jubilanceProvider.isJubilant(this, genome, housing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager) {
        this.beeModelProvider.registerModels(item, manager);
    }

    @Override
    public ModelResourceLocation getModel(EnumBeeType type) {
        return this.beeModelProvider.getModel(type);
    }

    @Override
    public int getSpriteColour(int renderPass) {
        return this.beeSpriteColourProvider.getSpriteColour(renderPass);
    }

    @Override
    public String getEntityTexture() {
        return null;
    }
}

