/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.utils.Log;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class Chromosome
implements IChromosome {
    private static final String UID0_TAG = "UID0";
    private static final String UID1_TAG = "UID1";
    @Nonnull
    private final IAllele primary;
    @Nonnull
    private final IAllele secondary;

    public Chromosome(@Nonnull IAllele allele) {
        this.primary = this.secondary = allele;
    }

    public Chromosome(@Nonnull IAllele primary, @Nonnull IAllele secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public Chromosome(@Nonnull NBTTagCompound nbt) {
        this.primary = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i(UID0_TAG));
        this.secondary = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i(UID1_TAG));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a(UID0_TAG, this.primary.getUID());
        nbttagcompound.func_74778_a(UID1_TAG, this.secondary.getUID());
    }

    @Override
    public IAllele getPrimaryAllele() {
        return this.primary;
    }

    @Override
    public IAllele getSecondaryAllele() {
        return this.secondary;
    }

    @Override
    public IAllele getActiveAllele() {
        if (this.primary == null || this.secondary == null) {
            return null;
        }
        if (this.primary.isDominant()) {
            return this.primary;
        }
        if (this.secondary.isDominant()) {
            return this.secondary;
        }
        return this.primary;
    }

    @Override
    public IAllele getInactiveAllele() {
        if (!this.secondary.isDominant()) {
            return this.secondary;
        }
        if (!this.primary.isDominant()) {
            return this.primary;
        }
        return this.secondary;
    }

    public IAllele getRandomAllele(Random rand) {
        if (rand.nextBoolean()) {
            return this.primary;
        }
        return this.secondary;
    }

    public boolean hasInvalidAlleles(Class<? extends IAllele> chromosomeClass) {
        if (this.primary == null) {
            Log.warning("Missing primary allele: {}", this);
            return true;
        }
        if (!chromosomeClass.isInstance(this.primary)) {
            Log.warning("Wrong primary allele for: {}. Should be: {}", this, chromosomeClass.getSimpleName());
            return true;
        }
        if (this.secondary == null) {
            Log.warning("Missing secondary allele: {}", this);
            return true;
        }
        if (!chromosomeClass.isInstance(this.secondary)) {
            Log.warning("Wrong secondary allele for: {}. Should be: {}", this, chromosomeClass.getSimpleName());
            return true;
        }
        return false;
    }

    public static IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    public String toString() {
        return "{" + this.primary + ", " + this.secondary + "}";
    }
}

