/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.IWoodProvider;
import forestry.api.core.ITextureManager;
import forestry.core.render.TextureManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WoodProviderVanilla
implements IWoodProvider {
    private final int vanillaMap;
    private TextureAtlasSprite woodTop;
    private TextureAtlasSprite woodBark;

    public WoodProviderVanilla(int vanillaMap) {
        this.vanillaMap = vanillaMap;
    }

    @Override
    public void registerSprites(Item item, ITextureManager manager) {
        String name = "";
        switch (this.vanillaMap) {
            case 0: {
                name = "oak";
                break;
            }
            case 1: {
                name = "spruce";
                break;
            }
            case 2: {
                name = "birch";
                break;
            }
            case 3: {
                name = "jungle";
                break;
            }
            case 4: {
                name = "acacia";
                break;
            }
            case 5: {
                name = "big_oak";
            }
        }
        this.woodTop = TextureManager.registerSprite(new ResourceLocation("minecraft:blocks/log_" + name + "_top"));
        this.woodBark = TextureManager.registerSprite(new ResourceLocation("minecraft:blocks/log_" + name));
    }

    @Override
    public TextureAtlasSprite getSprite(boolean isTop) {
        if (isTop) {
            return this.woodTop;
        }
        return this.woodBark;
    }

    @Override
    public ItemStack getWoodStack() {
        Block block = this.vanillaMap < 4 ? Blocks.field_150364_r : Blocks.field_150363_s;
        return new ItemStack(block, 1, this.vanillaMap >= 4 ? this.vanillaMap - 4 : this.vanillaMap);
    }
}

