/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.VectUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AlleleEffectSnowing
extends AlleleEffectThrottled {
    public AlleleEffectSnowing() {
        super("snowing", false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vec3i area = this.getModifiedArea(genome, housing);
        BlockPos offset = VectUtil.scale(area, -0.5f);
        for (int i = 0; i < 1; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);
            BlockPos posBlock = randomPos.func_177971_a((Vec3i)housing.getCoordinates());
            if (!world.isSideSolid(new BlockPos((posBlock = posBlock.func_177971_a((Vec3i)offset)).func_177958_n(), posBlock.func_177956_o() - 1, posBlock.func_177952_p()), EnumFacing.UP, false)) continue;
            IBlockState state = world.func_180495_p(posBlock);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150431_aC) {
                int meta = block.func_176201_c(state);
                if (meta >= 7) continue;
                world.func_175656_a(posBlock, block.func_176203_a(meta + 1));
                continue;
            }
            if (!block.func_176200_f((IBlockAccess)world, posBlock)) continue;
            world.func_175656_a(posBlock, Blocks.field_150431_aC.func_176223_P());
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorldObj().field_73012_v.nextInt(3) == 0) {
            Vec3i area = this.getModifiedArea(genome, housing);
            BlockPos offset = VectUtil.scale(area, -0.5f);
            BlockPos coordinates = housing.getCoordinates();
            World world = housing.getWorldObj();
            BlockPos spawn = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vec3i)coordinates).func_177971_a((Vec3i)offset);
            Proxies.render.addEntitySnowFX(world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

