/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import com.google.common.collect.LinkedListMultimap;
import forestry.Forestry;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.mail.gui.GuiMailboxInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.minecraftforge.common.config.Property;

public class Config {
    public static final String CATEGORY_COMMON = "common";
    public static final String CATEGORY_FLUIDS = "fluids";
    public static LocalizedConfiguration configCommon;
    public static LocalizedConfiguration configFluid;
    public static String gameMode;
    private static final Set<String> disabledStructures;
    private static final Set<String> disabledFluids;
    private static final Set<String> disabledBlocks;
    public static boolean isDebug;
    public static boolean enablePermissions;
    public static boolean enableParticleFX;
    public static boolean clearInvalidChromosomes;
    public static boolean pollinateVanillaTrees;
    public static float researchMutationBoostMultiplier;
    public static float maxResearchMutationBoostPercent;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    private static float generateBeehivesAmount;
    public static boolean generateBeehivesDebug;
    public static boolean logHivePlacement;
    public static boolean enableVillagers;
    public static boolean doRetrogen;
    public static boolean forceRetrogen;
    public static boolean enableBackpackResupply;
    private static boolean craftingBronzeEnabled;
    public static boolean craftingStampsEnabled;
    public static final ArrayList<String> collectorStamps;
    public static int farmSize;
    public static boolean squareFarms;
    private static boolean enableExUtilEnderLily;
    private static boolean enableMagicalCropsSupport;
    public static boolean mailAlertEnabled;
    public static GuiMailboxInfo.XPosition mailAlertXPosition;
    public static GuiMailboxInfo.YPosition mailAlertYPosition;
    public static int guiTabSpeed;
    public static boolean enableHints;
    public static final LinkedListMultimap<String, String> hints;
    public static boolean enableEnergyStat;

    public static boolean isStructureEnabled(String uid) {
        return !disabledStructures.contains(uid);
    }

    public static boolean isFluidEnabled(Fluids fluidDefinition) {
        return !disabledFluids.contains(fluidDefinition.getTag());
    }

    public static boolean isBlockEnabled(String tag) {
        return !disabledBlocks.contains(tag);
    }

    public static boolean isCraftingBronzeEnabled() {
        return craftingBronzeEnabled;
    }

    public static double getBeehivesAmount() {
        return generateBeehivesAmount;
    }

    public static boolean isExUtilEnderLilyEnabled() {
        return enableExUtilEnderLily;
    }

    public static boolean isMagicalCropsSupportEnabled() {
        return enableMagicalCropsSupport;
    }

    public static void load() {
        File configCommonFile = new File(Forestry.instance.getConfigFolder(), "common.cfg");
        Config.loadConfigCommon(configCommonFile);
        File configFluidsFile = new File(Forestry.instance.getConfigFolder(), "fluids.cfg");
        Config.loadConfigFluids(configFluidsFile);
        Config.loadHints();
    }

    private static void loadConfigCommon(File configFileCommon) {
        configCommon = new LocalizedConfiguration(configFileCommon, "1.2.0");
        gameMode = configCommon.getStringLocalized("difficulty", "game.mode", "EASY", new String[]{"OP, EASY, NORMAL, HARD"});
        boolean recreate = configCommon.getBooleanLocalized("difficulty", "recreate.definitions", true);
        if (recreate) {
            Log.info("Recreating all gamemode definitions from the defaults. This may be caused by an upgrade", new Object[0]);
            String recreateDefinitionsComment = Translator.translateToLocal("for.config.difficulty.recreate.definitions.comment");
            Property property = configCommon.get("difficulty", "recreate.definitions", true, recreateDefinitionsComment);
            property.set(false);
            File opMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/OP.cfg");
            Config.CopyFileToFS(opMode, "/config/forestry/gamemodes/OP.cfg");
            File normalMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/NORMAL.cfg");
            Config.CopyFileToFS(normalMode, "/config/forestry/gamemodes/NORMAL.cfg");
            File hardMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/HARD.cfg");
            Config.CopyFileToFS(hardMode, "/config/forestry/gamemodes/HARD.cfg");
        }
        enableParticleFX = configCommon.getBooleanLocalized("performance", "particleFX", enableParticleFX);
        doRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "normal", doRetrogen);
        if (forceRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "forced", forceRetrogen)) {
            Property property = configCommon.get("world.generate.retrogen", "forced", false);
            property.set(false);
            Log.info("Enabled force retrogen.", new Object[0]);
            doRetrogen = true;
        } else if (doRetrogen) {
            Log.info("Enabled retrogen.", new Object[0]);
        }
        generateBeehivesAmount = configCommon.getFloatLocalized("world.generate.beehives", "amount", generateBeehivesAmount, 0.0f, 10.0f);
        generateBeehivesDebug = configCommon.getBooleanLocalized("world.generate.beehives", "debug", generateBeehivesDebug);
        generateApatiteOre = configCommon.getBooleanLocalized("world.generate.ore", "apatite", generateApatiteOre);
        generateCopperOre = configCommon.getBooleanLocalized("world.generate.ore", "copper", generateCopperOre);
        generateTinOre = configCommon.getBooleanLocalized("world.generate.ore", "tin", generateTinOre);
        enableVillagers = configCommon.getBooleanLocalized("world.generate", "villagers", enableVillagers);
        craftingBronzeEnabled = configCommon.getBooleanLocalized("crafting", "bronze", craftingBronzeEnabled);
        craftingStampsEnabled = configCommon.getBooleanLocalized("crafting.stamps", "enabled", true);
        String[] allStamps = new String[]{"1n", "2n", "5n", "10n", "20n", "50n", "100n"};
        String[] defaultCollectors = new String[]{"20n", "50n", "100n"};
        String[] stamps = configCommon.getStringListLocalized("crafting.stamps", "disabled", defaultCollectors, allStamps);
        try {
            collectorStamps.addAll(Arrays.asList(stamps));
        }
        catch (RuntimeException ex) {
            Log.warning("Failed to read config for 'crafting.stamps.disabled', setting to default.", new Object[0]);
            Property property = configCommon.get("crafting.stamps", "disabled", defaultCollectors);
            property.setToDefault();
            collectorStamps.addAll(Arrays.asList(defaultCollectors));
        }
        clearInvalidChromosomes = configCommon.getBooleanLocalized("genetics", "clear.invalid.chromosomes", clearInvalidChromosomes);
        pollinateVanillaTrees = configCommon.getBooleanLocalized("genetics", "pollinate.vanilla.trees", pollinateVanillaTrees);
        researchMutationBoostMultiplier = configCommon.getFloatLocalized("genetics.research.boost", "multiplier", researchMutationBoostMultiplier, 1.0f, 1000.0f);
        maxResearchMutationBoostPercent = configCommon.getFloatLocalized("genetics.research.boost", "max.percent", maxResearchMutationBoostPercent, 0.0f, 100.0f);
        enableBackpackResupply = configCommon.getBooleanLocalized("performance", "backpacks.resupply", enableBackpackResupply);
        mailAlertEnabled = configCommon.getBooleanLocalized("tweaks.gui.mail.alert", "enabled", mailAlertEnabled);
        mailAlertXPosition = (GuiMailboxInfo.XPosition)configCommon.getEnumLocalized("tweaks.gui.mail.alert", "xPosition", mailAlertXPosition, GuiMailboxInfo.XPosition.values());
        mailAlertYPosition = (GuiMailboxInfo.YPosition)configCommon.getEnumLocalized("tweaks.gui.mail.alert", "yPosition", mailAlertYPosition, GuiMailboxInfo.YPosition.values());
        guiTabSpeed = configCommon.getIntLocalized("tweaks.gui.tabs", "speed", guiTabSpeed, 1, 50);
        enableHints = configCommon.getBooleanLocalized("tweaks.gui.tabs", "hints", enableHints);
        enableEnergyStat = configCommon.getBooleanLocalized("tweaks.gui.tabs", "energy", enableEnergyStat);
        enablePermissions = configCommon.getBooleanLocalized("tweaks", "permissions", enablePermissions);
        farmSize = configCommon.getIntLocalized("tweaks.farms", "size", farmSize, 1, 3);
        squareFarms = configCommon.getBooleanLocalized("tweaks.farms", "square", squareFarms);
        enableExUtilEnderLily = configCommon.getBooleanLocalized("tweaks.farms", "enderlily", enableExUtilEnderLily);
        enableMagicalCropsSupport = configCommon.getBooleanLocalized("tweaks.farms", "magicalcrops", enableMagicalCropsSupport);
        String[] availableStructures = new String[]{"alveary3x3", "farm3x3", "farm3x4", "farm3x5", "farm4x4", "farm5x5"};
        String[] disabledStructureArray = disabledStructures.toArray(new String[disabledStructures.size()]);
        disabledStructureArray = configCommon.getStringListLocalized("structures", "disabled", disabledStructureArray, availableStructures);
        disabledStructures.addAll(Arrays.asList(disabledStructureArray));
        for (String str : disabledStructures) {
            Log.debug("Disabled structure '%s'.", str);
        }
        isDebug = configCommon.getBooleanLocalized("debug", "enabled", isDebug);
        configCommon.save();
    }

    private static void loadConfigFluids(File configFile) {
        configFluid = new LocalizedConfiguration(configFile, "1.0.0");
        for (Fluids fluid : Fluids.FORESTRY_FLUIDs) {
            String fluidName = Translator.translateToLocal("fluid." + fluid.getTag());
            boolean enabledFluid = !disabledFluids.contains(fluid.getTag());
            String enableFluidComment = Translator.translateToLocalFormatted("for.config.fluids.enable.format", fluidName);
            enabledFluid = configFluid.getBoolean("enableFluid", fluid.getTag(), enabledFluid, enableFluidComment);
            if (!enabledFluid) {
                disabledFluids.add(fluid.getTag());
            }
            boolean enabledFluidBlock = !disabledBlocks.contains(fluid.getTag());
            String enableFluidBlockComment = Translator.translateToLocalFormatted("for.config.fluid.blocks.enable.format", fluidName);
            enabledFluidBlock = configFluid.getBoolean("enableFluidBlock", fluid.getTag(), enabledFluidBlock, enableFluidBlockComment);
            if (enabledFluidBlock) continue;
            disabledBlocks.add(fluid.getTag());
        }
        configFluid.save();
    }

    private static void CopyFileToFS(File destination, String resourcePath) {
        InputStream stream = Config.class.getResourceAsStream(resourcePath);
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            if (!destination.exists() && !destination.createNewFile()) {
                return;
            }
            FileOutputStream outstream = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)outstream).write(buffer, 0, readBytes);
            }
        }
        catch (FileNotFoundException e) {
            Log.error("File not found.", e);
        }
        catch (IOException e) {
            Log.error("Failed to copy file.", e);
        }
    }

    private static void loadHints() {
        Properties prop = new Properties();
        try {
            InputStream hintStream = Config.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (IOException e) {
            Log.error("Failed to load hints file.", e);
        }
        for (String key : prop.stringPropertyNames()) {
            String[] parsedHints = Config.parseHints(prop.getProperty(key));
            if (parsedHints == null) continue;
            for (String parsedHint : parsedHints) {
                hints.put((Object)key, (Object)parsedHint);
            }
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    static {
        disabledStructures = new HashSet<String>();
        disabledFluids = new HashSet<String>();
        disabledBlocks = new HashSet<String>();
        isDebug = false;
        enablePermissions = true;
        enableParticleFX = true;
        clearInvalidChromosomes = false;
        pollinateVanillaTrees = true;
        researchMutationBoostMultiplier = 1.5f;
        maxResearchMutationBoostPercent = 5.0f;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        generateBeehivesAmount = 1.0f;
        generateBeehivesDebug = false;
        logHivePlacement = false;
        enableVillagers = true;
        doRetrogen = false;
        forceRetrogen = false;
        enableBackpackResupply = true;
        craftingBronzeEnabled = true;
        craftingStampsEnabled = true;
        collectorStamps = new ArrayList();
        farmSize = 2;
        squareFarms = false;
        enableExUtilEnderLily = true;
        enableMagicalCropsSupport = true;
        mailAlertEnabled = true;
        mailAlertXPosition = GuiMailboxInfo.XPosition.LEFT;
        mailAlertYPosition = GuiMailboxInfo.YPosition.TOP;
        guiTabSpeed = 8;
        enableHints = true;
        hints = LinkedListMultimap.create();
        enableEnergyStat = true;
    }
}

