/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.FluidHelper;
import forestry.core.items.DrinkProperties;
import forestry.core.items.EnumContainerType;
import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public enum Fluids {
    BIO_ETHANOL(new Color(255, 111, 0), 790, 1000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 300, true);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    BIOMASS(new Color(100, 132, 41), 400, 6560){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 100, true);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    GLASS(new Color(164, 164, 164), 2400, 10000){

        @Override
        public int getTemperature() {
            return 1200;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 0, true);
        }
    }
    ,
    FOR_HONEY(new Color(255, 196, 35), 1420, 73600){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 64);
        }
    }
    ,
    ICE(new Color(175, 242, 255), 920, 1000){

        @Override
        public int getTemperature() {
            return 265;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    JUICE(new Color(168, 201, 114)){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 32);
        }
    }
    ,
    MILK(new Color(255, 255, 255), 1030, 3000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        @Nonnull
        public List<ItemStack> getOtherContainers() {
            return Collections.singletonList(new ItemStack(Items.field_151117_aB));
        }
    }
    ,
    SEED_OIL(new Color(255, 255, 168), 885, 5000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 2, true);
        }

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    SHORT_MEAD(new Color(239, 154, 56), 1000, 1200){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }
    }
    ,
    WATER(new Color(2372332)){

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    LAVA(new Color(16598559)){

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.REFRACTORY);
        }
    }
    ,
    FUEL(new Color(0xFFFF00)){

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    OIL(new Color(0x404040)){

        @Override
        @Nonnull
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    CREOSOTE(new Color(6511619)),
    STEAM(new Color(9540495));

    public static final Fluids[] FORESTRY_FLUIDs;
    private static final Map<String, Fluids> tagToFluid;
    private final String tag;
    private final int density;
    private final int viscosity;
    @Nonnull
    private final Color color;
    private final ResourceLocation[] resources = new ResourceLocation[2];

    private Fluids(Color color) {
        this(color, 1000, 1000);
    }

    private Fluids(Color color, int density, int viscosity) {
        this.tag = this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');
        this.color = color;
        this.density = density;
        this.viscosity = viscosity;
        this.resources[0] = new ForestryResource("blocks/liquid/" + this.getTag() + "_still");
        if (this.flowTextureExists()) {
            this.resources[1] = new ForestryResource("blocks/liquid/" + this.getTag() + "_flow");
        }
    }

    public int getTemperature() {
        return 295;
    }

    public final String getTag() {
        return this.tag;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.getTag());
    }

    public final FluidStack getFluid(int mb) {
        return FluidRegistry.getFluidStack((String)this.getTag(), (int)mb);
    }

    public final Block getBlock() {
        Fluid fluid = this.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getBlock();
    }

    @Nonnull
    public final Color getColor() {
        return this.color;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return fluidStack != null && this.getFluid() == fluidStack.getFluid();
    }

    public final boolean isContained(ItemStack containerStack) {
        return containerStack != null && FluidHelper.containsFluid(containerStack, this.getFluid());
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        if (fluidStack != null && fluid == fluidStack.getFluid()) {
            return true;
        }
        return fluid == null && fluidStack == null;
    }

    public static boolean areEqual(FluidStack a, FluidStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isFluidEqual(b);
    }

    @Nonnull
    public static Color getFluidColor(FluidStack fluidStack) {
        Fluids fluidDefinition;
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null && (fluidDefinition = tagToFluid.get(fluid.getName())) != null) {
            return fluidDefinition.getColor();
        }
        return WATER.getColor();
    }

    @Nonnull
    public EnumSet<EnumContainerType> getContainerTypes() {
        return EnumSet.noneOf(EnumContainerType.class);
    }

    @Nonnull
    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    @Nullable
    public Block makeBlock() {
        return null;
    }

    @Nullable
    public DrinkProperties getDrinkProperties() {
        return null;
    }

    public boolean flowTextureExists() {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return true;
        }
        try {
            ForestryResource resourceLocation = new ForestryResource("blocks/liquid/" + this.getTag() + "_flow");
            IResourceManager resourceManager = Proxies.common.getClientInstance().func_110442_L();
            return resourceManager.func_110536_a((ResourceLocation)resourceLocation) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public ResourceLocation[] getResources() {
        return this.resources;
    }

    static {
        FORESTRY_FLUIDs = new Fluids[]{BIO_ETHANOL, BIOMASS, GLASS, FOR_HONEY, ICE, JUICE, MILK, SEED_OIL, SHORT_MEAD};
        tagToFluid = new HashMap<String, Fluids>();
        for (Fluids fluidDefinition : Fluids.values()) {
            tagToFluid.put(fluidDefinition.getTag(), fluidDefinition);
        }
    }
}

