/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumLeafType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutationCustom;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.genetics.ITreeDefinition;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.genetics.alleles.AlleleGrowth;
import forestry.arboriculture.models.ModelProviderGermling;
import forestry.arboriculture.models.ModelProviderGermlingVanilla;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenAcaciaVanilla;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBaobab;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenCocobolo;
import forestry.arboriculture.worldgen.WorldGenDarkOak;
import forestry.arboriculture.worldgen.WorldGenDate;
import forestry.arboriculture.worldgen.WorldGenEbony;
import forestry.arboriculture.worldgen.WorldGenGiganteum;
import forestry.arboriculture.worldgen.WorldGenGreenheart;
import forestry.arboriculture.worldgen.WorldGenIpe;
import forestry.arboriculture.worldgen.WorldGenJungle;
import forestry.arboriculture.worldgen.WorldGenKapok;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLemon;
import forestry.arboriculture.worldgen.WorldGenMahoe;
import forestry.arboriculture.worldgen.WorldGenMahogany;
import forestry.arboriculture.worldgen.WorldGenMaple;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenPadauk;
import forestry.arboriculture.worldgen.WorldGenPapaya;
import forestry.arboriculture.worldgen.WorldGenPine;
import forestry.arboriculture.worldgen.WorldGenPlum;
import forestry.arboriculture.worldgen.WorldGenPoplar;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenSilverLime;
import forestry.arboriculture.worldgen.WorldGenSpruce;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.arboriculture.worldgen.WorldGenWenge;
import forestry.arboriculture.worldgen.WorldGenWillow;
import forestry.arboriculture.worldgen.WorldGenZebrawood;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.tiles.TileUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public enum TreeDefinition implements ITreeDefinition,
ITreeGenerator,
IStringSerializable
{
    Oak(TreeBranchDefinition.QUERCUS, "appleOak", "robur", false, EnumLeafType.DECIDUOUS, new Color(4764952), new Color(4764952).brighter(), 0, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenOak(tree);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitApple);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    DarkOak(TreeBranchDefinition.QUERCUS, "darkOak", "velutina", false, EnumLeafType.DECIDUOUS, new Color(4764952), new Color(4764952).brighter(), 5, Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenDarkOak(tree);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FASTER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Birch(TreeBranchDefinition.BETULA, "silverBirch", "pendula", false, EnumLeafType.DECIDUOUS, new Color(8431445), new Color(11585096), 2, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBirch(tree);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Lime(TreeBranchDefinition.TILIA, "silverLime", "pendula", true, EnumLeafType.DECIDUOUS, new Color(6201607), new Color(6201607).brighter(), EnumWoodType.LIME){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenSilverLime(tree);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.LOWER);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Birch, Oak, 15);
        }
    }
    ,
    Walnut(TreeBranchDefinition.JUGLANS, "commonWalnut", "regia", true, EnumLeafType.DECIDUOUS, new Color(7965781), new Color(11585096), EnumWoodType.WALNUT){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenWalnut(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitWalnut);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Cherry, 10);
        }
    }
    ,
    Chestnut(TreeBranchDefinition.CASTANEA, "sweetChestnut", "sativa", true, EnumLeafType.DECIDUOUS, new Color(6201607), new Color(11585096), EnumWoodType.CHESTNUT){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenChestnut(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitChestnut);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Walnut, Lime, 10);
            this.registerMutation(Walnut, Cherry, 10);
        }
    }
    ,
    Cherry(TreeBranchDefinition.PRUNUS, "hillCherry", "serrulata", true, EnumLeafType.DECIDUOUS, new Color(15110618), new Color(15089241), EnumWoodType.CHERRY){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenCherry(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitCherry);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALLER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Oak, 10);
            this.registerMutation(Lime, Birch, 10);
        }
    }
    ,
    Lemon(TreeBranchDefinition.CITRUS, "lemon", "limon", true, EnumLeafType.DECIDUOUS, new Color(8957780), new Color(10729552), EnumWoodType.CITRUS){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitLemon);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALLEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lime, Cherry, 5);
        }
    }
    ,
    Plum(TreeBranchDefinition.PRUNUS, "plum", "domestica", true, EnumLeafType.DECIDUOUS, new Color(5804614), new Color(10729552), EnumWoodType.PLUM){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitPlum);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.HIGH);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALLEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lemon, Cherry, 5);
        }
    }
    ,
    Maple(TreeBranchDefinition.ACER, "sugarMaple", "saccharum", true, EnumLeafType.MAPLE, new Color(13956133), new Color(6396476), EnumWoodType.MAPLE){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenMaple(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Larch, 5);
        }
    }
    ,
    Spruce(TreeBranchDefinition.PICEA, "redSpruce", "abies", false, EnumLeafType.CONIFERS, new Color(0x619961), new Color(5479698), 1, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenSpruce(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Larch(TreeBranchDefinition.LARIX, "mundaneLarch", "decidua", true, EnumLeafType.CONIFERS, new Color(6918032), new Color(5675158), EnumWoodType.LARCH){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLarch(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Birch, 10);
            this.registerMutation(Spruce, Oak, 10);
        }
    }
    ,
    Pine(TreeBranchDefinition.PINUS, "bullPine", "sabiniana", true, EnumLeafType.CONIFERS, new Color(0xFEFF8F), new Color(16767375), EnumWoodType.PINE){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPine(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Spruce, Larch, 10);
        }
    }
    ,
    Sequoia(TreeBranchDefinition.SEQUOIA, "coastSequoia", "sempervirens", false, EnumLeafType.CONIFERS, new Color(4296305), new Color(5675158), EnumWoodType.SEQUOIA){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenSequoia(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGEST);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 3);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FIREPROOF, EnumAllele.Fireproof.TRUE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Larch, Pine, 5);
        }
    }
    ,
    Gigant(TreeBranchDefinition.SEQUOIADENDRON, "giantSequoia", "giganteum", false, EnumLeafType.CONIFERS, new Color(7570484), new Color(7570484).brighter(), EnumWoodType.GIGANTEUM){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenGiganteum(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.setComplexity(10);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.GIGANTIC);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWEST);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOWEST);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 4);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FIREPROOF, EnumAllele.Fireproof.TRUE);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Jungle(TreeBranchDefinition.TROPICAL, "jungle", "tectona", false, EnumLeafType.JUNGLE, new Color(4764952), new Color(6654231), 3, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitCocoa);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FAST);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Teak(TreeBranchDefinition.TECTONA, "teak", "grandis", true, EnumLeafType.JUNGLE, new Color(0xFEFF8F), new Color(16767375), EnumWoodType.TEAK){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTeak(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DarkOak, Jungle, 10);
        }
    }
    ,
    Ipe(TreeBranchDefinition.TABEBUIA, "ipe", "serratifolia", true, EnumLeafType.JUNGLE, new Color(16634375), new Color(11374340), EnumWoodType.IPE){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenIpe(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, DarkOak, 10);
        }
    }
    ,
    Kapok(TreeBranchDefinition.CEIBA, "kapok", "pentandra", true, EnumLeafType.JUNGLE, new Color(9017467), new Color(9022110), EnumWoodType.KAPOK){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenKapok(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.PRUNES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Teak, 10);
        }
    }
    ,
    Ebony(TreeBranchDefinition.EBONY, "myrtleEbony", "pentamera", true, EnumLeafType.JUNGLE, new Color(10670666), new Color(12898890), EnumWoodType.EBONY){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenEbony(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.PRUNES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 3);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DarkOak, Kapok, 10);
        }
    }
    ,
    Zebrawood(TreeBranchDefinition.ASTRONIUM, "zebrawood", "graveolens", false, EnumLeafType.JUNGLE, new Color(10670666), new Color(12898890), EnumWoodType.ZEBRAWOOD){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenZebrawood(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Ebony, Poplar, 5);
        }
    }
    ,
    Mahogony(TreeBranchDefinition.MAHOGANY, "yellowMeranti", "gibbosa", true, EnumLeafType.JUNGLE, new Color(9089364), new Color(11120980), EnumWoodType.MAHOGANY){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenMahogany(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Kapok, Ebony, 10);
        }
    }
    ,
    AcaciaVanilla(TreeBranchDefinition.ACACIA, "acacia", "aneura", true, EnumLeafType.DECIDUOUS, new Color(0x616101), new Color(11776770), 4, Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA)){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenAcaciaVanilla(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Acacia(TreeBranchDefinition.ACACIA, "desertAcacia", "erioloba", true, EnumLeafType.DECIDUOUS, new Color(7638044), new Color(11776770), EnumWoodType.ACACIA){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenAcacia(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.PLANT, AllelePlantType.plantTypeDesert);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, Balsa, 10);
        }
    }
    ,
    Padauk(TreeBranchDefinition.PTEROCARPUS, "padauk", "soyauxii", true, EnumLeafType.DECIDUOUS, new Color(13688716), new Color(4414514), EnumWoodType.PADAUK){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPadauk(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(AcaciaVanilla, Jungle, 10);
        }
    }
    ,
    Balsa(TreeBranchDefinition.OCHROMA, "balsa", "pyramidale", true, EnumLeafType.DECIDUOUS, new Color(5876736), new Color(0xFEFF8F), EnumWoodType.BALSA){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBalsa(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.HIGH);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Teak, AcaciaVanilla, 10);
        }
    }
    ,
    Cocobolo(TreeBranchDefinition.DALBERGIA, "cocobolo", "retusa", false, EnumLeafType.DECIDUOUS, new Color(6988154), new Color(4750668), EnumWoodType.COCOBOLO){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenCocobolo(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Acacia, DarkOak, 10);
        }
    }
    ,
    Wenge(TreeBranchDefinition.MILLETTIA, "wenge", "laurentii", true, EnumLeafType.DECIDUOUS, new Color(11379031), new Color(11373143), EnumWoodType.WENGE){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenWenge(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOWEST);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Cocobolo, Balsa, 10);
        }
    }
    ,
    Baobab(TreeBranchDefinition.ADANSONIA, "grandidierBaobab", "digitata", true, EnumLeafType.DECIDUOUS, new Color(0xFEFF8F), new Color(16767375), EnumWoodType.BAOBAB){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBaobab(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.PLANT, AllelePlantType.plantTypeDesert);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GIRTH, 3);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Balsa, Wenge, 10);
        }
    }
    ,
    Mahoe(TreeBranchDefinition.TALIPARITI, "blueMahoe", "elatum", true, EnumLeafType.DECIDUOUS, new Color(10533403), new Color(7971189), EnumWoodType.MAHOE){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenMahoe(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.POMES).addFruitFamily(EnumFruitFamily.PRUNES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALL);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.HIGH);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOWEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Balsa, Acacia, 5);
        }
    }
    ,
    Willow(TreeBranchDefinition.SALIX, "whiteWillow", "alba", true, EnumLeafType.WILLOW, new Color(10729637), new Color(10729552), EnumWoodType.WILLOW){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenWillow(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.NUX).addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.FASTER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Oak, Birch, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
            this.registerMutation(Oak, Lime, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
            this.registerMutation(Lime, Birch, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    Sipiri(TreeBranchDefinition.CHLOROCARDIUM, "sipiri", "rodiei", true, EnumLeafType.DECIDUOUS, new Color(6785297), new Color(7971189), EnumWoodType.GREENHEART){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenGreenheart(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.GROWTH, AlleleGrowth.growthTropical);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.LARGE);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Kapok, Mahogony, 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    Papaya(TreeBranchDefinition.CARICA, "papaya", "papaya", true, EnumLeafType.PALM, new Color(7184216), new Color(7726709), EnumWoodType.PAPAYA){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPapaya(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitPapaya);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWER);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Cherry, 5);
        }
    }
    ,
    Date(TreeBranchDefinition.PHOENIX, "datePalm", "dactylifera", true, EnumLeafType.PALM, new Color(13356409), new Color(11793264), EnumWoodType.PALM){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenDate(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.JUNGLE).addFruitFamily(EnumFruitFamily.NUX);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FRUITS, AlleleFruit.fruitDates);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.YIELD, EnumAllele.Yield.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Jungle, Papaya, 5);
        }
    }
    ,
    Poplar(TreeBranchDefinition.POPULUS, "whitePoplar", "alba", true, EnumLeafType.DECIDUOUS, new Color(10729637), new Color(5479698), EnumWoodType.POPLAR){

        @Override
        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPoplar(tree);
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder treeSpecies) {
            treeSpecies.addFruitFamily(EnumFruitFamily.PRUNES).addFruitFamily(EnumFruitFamily.POMES);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALL);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOW);
            AlleleHelper.instance.set(alleles, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.SLOWER);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Birch, Willow, 5);
            this.registerMutation(Oak, Willow, 5);
            this.registerMutation(Lime, Willow, 5);
        }
    };

    public static TreeDefinition[] VALUES;
    private final TreeBranchDefinition branch;
    private final IAlleleTreeSpecies species;
    private final EnumWoodType woodType;
    private final IBlockState vanillaWood;
    private IAllele[] template;
    private ITreeGenome genome;

    private TreeDefinition(TreeBranchDefinition branch, String speciesName, String binomial, boolean dominant, EnumLeafType leafType, Color primary, Color secondary, int vanillaMeta, IBlockState vanillaWood) {
        String uid = "forestry.tree" + this;
        String unlocalizedDescription = "for.description.tree" + this;
        String unlocalizedName = "for.trees.species." + speciesName;
        String modelName = uid.substring("forestry.".length());
        this.branch = branch;
        ILeafSpriteProvider leafIconProvider = TreeManager.treeFactory.getLeafIconProvider(leafType, primary, secondary);
        ModelProviderGermlingVanilla germlingIconProvider = new ModelProviderGermlingVanilla(vanillaMeta);
        IAlleleTreeSpeciesBuilder speciesBuilder = TreeManager.treeFactory.createSpecies(uid, unlocalizedName, "Sengir", unlocalizedDescription, dominant, branch.getBranch(), binomial, "Forestry", modelName, leafIconProvider, germlingIconProvider, this);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        this.woodType = null;
        this.vanillaWood = vanillaWood;
    }

    private TreeDefinition(TreeBranchDefinition branch, String speciesName, String binomial, boolean dominant, EnumLeafType leafType, Color primary, Color secondary, EnumWoodType woodType) {
        String uid = "Forestry.tree" + this;
        String unlocalizedDescription = "for.description.tree" + this;
        String unlocalizedName = "for.trees.species." + speciesName;
        String modelName = uid.substring("forestry.".length());
        this.branch = branch;
        ILeafSpriteProvider leafIconProvider = TreeManager.treeFactory.getLeafIconProvider(leafType, primary, secondary);
        ModelProviderGermling germlingIconProvider = new ModelProviderGermling(uid);
        IAlleleTreeSpeciesBuilder speciesBuilder = TreeManager.treeFactory.createSpecies(uid, unlocalizedName, "Sengir", unlocalizedDescription, dominant, branch.getBranch(), binomial, "Forestry", modelName, leafIconProvider, germlingIconProvider, this);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        this.woodType = woodType;
        this.vanillaWood = null;
    }

    protected abstract void setSpeciesProperties(IAlleleTreeSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    @Override
    public boolean setLogBlock(ITreeGenome genome, World world, BlockPos pos, EnumFacing facing) {
        IBlockState logBlock;
        if (this.woodType == null) {
            logBlock = this.vanillaWood;
        } else {
            AlleleBoolean fireproofAllele = (AlleleBoolean)genome.getActiveAllele(EnumTreeChromosome.FIREPROOF);
            boolean fireproof = fireproofAllele.getValue();
            logBlock = TreeManager.woodAccess.getLogBlock(this.woodType, fireproof);
        }
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k());
        return world.func_175656_a(pos, logBlock.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
    }

    @Override
    public boolean setLeaves(ITreeGenome genome, World world, GameProfile owner, BlockPos pos) {
        boolean placed = world.func_175656_a(pos, PluginArboriculture.blocks.leaves.func_176223_P());
        if (!placed) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (PluginArboriculture.blocks.leaves != block) {
            world.func_175698_g(pos);
            return false;
        }
        TileLeaves tileLeaves = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (tileLeaves == null) {
            world.func_175698_g(pos);
            return false;
        }
        tileLeaves.setOwner(owner);
        tileLeaves.setTree(new Tree(genome));
        world.func_175704_b(pos, pos);
        return true;
    }

    public static void initTrees() {
        for (TreeDefinition tree : TreeDefinition.values()) {
            tree.init();
        }
        for (TreeDefinition tree : TreeDefinition.values()) {
            tree.registerMutations();
        }
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, EnumTreeChromosome.SPECIES, this.species);
        this.setAlleles(this.template);
        this.genome = TreeManager.treeRoot.templateAsGenome(this.template);
        TreeManager.treeRoot.registerTemplate(this.template);
    }

    protected final ITreeMutationCustom registerMutation(TreeDefinition parent1, TreeDefinition parent2, int chance) {
        return TreeManager.treeMutationFactory.createMutation(parent1.species, parent2.species, this.getTemplate(), chance);
    }

    @Override
    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final String getUID() {
        return this.species.getUID();
    }

    @Override
    public final ITreeGenome getGenome() {
        return this.genome;
    }

    @Override
    public final ITree getIndividual() {
        return new Tree(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumGermlingType treeType) {
        ITree tree = this.getIndividual();
        return TreeManager.treeRoot.getMemberStack(tree, treeType);
    }

    public static void preInit() {
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public int getMetadata() {
        return this.ordinal();
    }

    public static TreeDefinition byMetadata(int meta) {
        if (meta < 0 || meta >= VALUES.length) {
            meta = 0;
        }
        return VALUES[meta];
    }

    static {
        VALUES = TreeDefinition.values();
    }
}

