/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemStackUtil {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77952_i() != Short.MAX_VALUE && lhs.func_77952_i() != rhs.func_77952_i()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    public static ResourceLocation getItemNameFromRegistry(Item item) {
        if (item == null) {
            return null;
        }
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        return itemRegistry.getNameForObject((IForgeRegistryEntry)item);
    }

    @Nullable
    public static String getItemNameFromRegistryAsString(Item item) {
        ResourceLocation itemNameFromRegistry = ItemStackUtil.getItemNameFromRegistry(item);
        if (itemNameFromRegistry == null) {
            return null;
        }
        return itemNameFromRegistry.toString();
    }

    @Nullable
    public static String getStringForItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        String itemStackString = ItemStackUtil.getItemNameFromRegistryAsString(item);
        if (itemStackString == null) {
            return null;
        }
        int meta = itemStack.func_77952_i();
        if (meta != Short.MAX_VALUE) {
            return itemStackString + ':' + meta;
        }
        return itemStackString;
    }

    public static Item getItemFromRegistry(String itemName) {
        return ItemStackUtil.getItemFromRegistry(new ResourceLocation(itemName));
    }

    public static Item getItemFromRegistry(ResourceLocation itemName) {
        if (itemName == null) {
            return null;
        }
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        int registryID = itemRegistry.getId(itemName);
        if (registryID == -1) {
            return null;
        }
        return (Item)itemRegistry.getRaw(registryID);
    }

    public static ResourceLocation getBlockNameFromRegistry(Block block) {
        if (block == null) {
            return null;
        }
        FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
        return blockRegistry.getNameForObject((IForgeRegistryEntry)block);
    }

    public static String getBlockNameFromRegistryAsSting(Block block) {
        return ItemStackUtil.getBlockNameFromRegistry(block).toString();
    }

    public static Block getBlockFromRegistry(String itemName) {
        return ItemStackUtil.getBlockFromRegistry(new ResourceLocation(itemName));
    }

    public static Block getBlockFromRegistry(ResourceLocation itemName) {
        if (itemName == null) {
            return null;
        }
        FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
        int registryID = blockRegistry.getId(itemName);
        if (registryID == -1) {
            return null;
        }
        return (Block)blockRegistry.getRaw(registryID);
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.field_77994_a >= 64) {
            return;
        }
        if (!receptor.func_77969_a(giver)) {
            return;
        }
        if (giver.field_77994_a <= receptor.func_77976_d() - receptor.field_77994_a) {
            receptor.field_77994_a += giver.field_77994_a;
            giver.field_77994_a = 0;
            return;
        }
        ItemStack temp = giver.func_77979_a(receptor.func_77976_d() - receptor.field_77994_a);
        receptor.field_77994_a += temp.field_77994_a;
        temp.field_77994_a = 0;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.func_77973_b(), amount, stack.func_77952_i());
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.func_77978_p().func_74737_b();
            split.func_77982_d(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)cached, (ItemStack)stack)) continue;
                cached.field_77994_a += stack.field_77994_a;
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            condensed.add(cached);
        }
        return condensed.toArray(new ItemStack[condensed.size()]);
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!ItemStackUtil.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return ItemStackUtil.containsSets(set, stock, false, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, boolean oreDictionary, boolean craftingTools) {
        int totalSets = 0;
        ItemStack[] condensedRequired = ItemStackUtil.condenseStacks(set);
        ItemStack[] condensedOffered = ItemStackUtil.condenseStacks(stock);
        for (ItemStack req : condensedRequired) {
            int reqCount = 0;
            for (ItemStack offer : condensedOffered) {
                if (!ItemStackUtil.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.field_77994_a / req.field_77994_a);
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return 0;
            }
            if (totalSets == 0) {
                totalSets = reqCount;
                continue;
            }
            if (totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return totalSets;
    }

    public static boolean equalSets(ItemStack[] set1, ItemStack[] set2) {
        if (set1 == set2) {
            return true;
        }
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.length != set2.length) {
            return false;
        }
        for (int i = 0; i < set1.length; ++i) {
            if (ItemStackUtil.isIdenticalItem(set1[i], set2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77952_i() != Short.MAX_VALUE && base.func_77952_i() != comparison.func_77952_i()) {
            return false;
        }
        if (!base.func_77942_o() || base.func_77978_p().func_82582_d()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        if (ItemStackUtil.isCraftingEquivalent(base, comparison)) {
            return true;
        }
        if (base == null || comparison == null) {
            return false;
        }
        if (craftingTools && ItemStackUtil.isCraftingToolEquivalent(base, comparison)) {
            return true;
        }
        if (base.func_77942_o() && !base.func_77978_p().func_82582_d() && !ItemStack.func_77989_b((ItemStack)base, (ItemStack)comparison)) {
            return false;
        }
        if (oreDictionary) {
            int[] idsBase = OreDictionary.getOreIDs((ItemStack)base);
            Arrays.sort(idsBase);
            int[] idsComp = OreDictionary.getOreIDs((ItemStack)comparison);
            Arrays.sort(idsComp);
            int iBase = 0;
            int iComp = 0;
            while (iBase < idsBase.length && iComp < idsComp.length) {
                if (idsBase[iBase] < idsComp[iComp]) {
                    ++iBase;
                    continue;
                }
                if (idsBase[iBase] > idsComp[iComp]) {
                    ++iComp;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isCraftingToolEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        Item baseItem = base.func_77973_b();
        if (baseItem != comparison.func_77973_b()) {
            return false;
        }
        if (!base.func_77942_o() || base.func_77978_p().func_82582_d()) {
            return true;
        }
        if (base.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return base.func_77952_i() == comparison.func_77952_i();
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        ItemStackUtil.dropItemStackAsEntity(items, world, x, y, z, 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, BlockPos pos) {
        ItemStackUtil.dropItemStackAsEntity(items, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 10);
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z, int delayForPickup) {
        if (items.field_77994_a <= 0 || world.field_72995_K) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.func_174867_a(delayForPickup);
        world.func_72838_d((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = rand.nextInt(max);
        ItemStack created = template.func_77946_l();
        created.field_77994_a = size <= 0 ? 1 : (size > created.func_77976_d() ? created.func_77976_d() : size);
        return created;
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack);
    }

    public static boolean equals(IBlockState state, ItemStack stack) {
        return state.func_177230_c() == ItemStackUtil.getBlock(stack) && state.func_177230_c().func_176201_c(state) == stack.func_77952_i();
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        return block == ItemStackUtil.getBlock(stack) && meta == stack.func_77952_i();
    }

    public static List<ItemStack> parseItemStackStrings(String[] itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    public static List<ItemStack> parseItemStackStrings(String itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = Stack.parseStackStrings(itemStackStrings, missingMetaValue);
        return ItemStackUtil.getItemStacks(stacks);
    }

    public static ItemStack parseItemStackString(String itemStackString, int missingMetaValue) {
        Stack stack = Stack.parseStackString(itemStackString, missingMetaValue);
        return ItemStackUtil.getItemStack(stack);
    }

    private static List<ItemStack> getItemStacks(List<Stack> stacks) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(stacks.size());
        for (Stack stack : stacks) {
            Item item = stack.getItem();
            if (item == null) continue;
            int meta = stack.getMeta();
            ItemStack itemStack = new ItemStack(item, 1, meta);
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    private static ItemStack getItemStack(Stack stack) {
        Item item = stack.getItem();
        if (item != null) {
            int meta = stack.getMeta();
            return new ItemStack(item, 1, meta);
        }
        return null;
    }
}

