/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.core.config.Config;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeAlyzerPlugin
implements IAlyzerPlugin {
    public static final TreeAlyzerPlugin INSTANCE = new TreeAlyzerPlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private TreeAlyzerPlugin() {
        ArrayList<ItemStack> treeList = new ArrayList<ItemStack>();
        PluginArboriculture.items.sapling.addCreativeItems(treeList, false);
        for (ItemStack treeStack : treeList) {
            IAlleleTreeSpecies species = TreeGenome.getSpecies(treeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), treeStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage1(GuiAlyzer gui, ItemStack itemStack) {
        ITree tree = TreeManager.treeRoot.getMember(itemStack);
        if (tree == null) {
            return;
        }
        EnumGermlingType type = TreeManager.treeRoot.getType(itemStack);
        TextLayoutHelper textLayout = gui.getTextLayout();
        textLayout.startPage(12, 90, 155);
        textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
        textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
        textLayout.newLine();
        textLayout.newLine();
        String customPrimaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getPrimary().getUnlocalizedName().replace("trees.species.", "");
        String customSecondaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getSecondary().getUnlocalizedName().replace("trees.species.", "");
        gui.drawSpeciesRow(Translator.translateToLocal("for.gui.species"), tree, EnumTreeChromosome.SPECIES, GuiAlyzer.checkCustomName(customPrimaryTreeKey), GuiAlyzer.checkCustomName(customSecondaryTreeKey));
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.saplings"), tree, EnumTreeChromosome.FERTILITY);
        textLayout.newLineCompressed();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.maturity"), tree, EnumTreeChromosome.MATURATION);
        textLayout.newLineCompressed();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.height"), tree, EnumTreeChromosome.HEIGHT);
        textLayout.newLineCompressed();
        IAlleleInteger activeGirth = (IAlleleInteger)tree.getGenome().getActiveAllele(EnumTreeChromosome.GIRTH);
        IAlleleInteger inactiveGirth = (IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GIRTH);
        textLayout.drawLine(Translator.translateToLocal("for.gui.girth"), 12);
        gui.drawLine(String.format("%sx%s", activeGirth.getValue(), activeGirth.getValue()), 90, tree, EnumTreeChromosome.GIRTH, false);
        gui.drawLine(String.format("%sx%s", inactiveGirth.getValue(), inactiveGirth.getValue()), 155, tree, EnumTreeChromosome.GIRTH, true);
        textLayout.newLineCompressed();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.yield"), tree, EnumTreeChromosome.YIELD);
        textLayout.newLineCompressed();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.sappiness"), tree, EnumTreeChromosome.SAPPINESS);
        textLayout.newLineCompressed();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.effect"), tree, EnumTreeChromosome.EFFECT);
        textLayout.endPage();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage2(GuiAlyzer gui, ItemStack itemStack) {
        ITree tree = TreeManager.treeRoot.getMember(itemStack);
        if (tree == null) {
            return;
        }
        TextLayoutHelper textLayout = gui.getTextLayout();
        textLayout.startPage();
        int speciesDominance0 = gui.getColorCoding(tree.getGenome().getPrimary().isDominant());
        int speciesDominance1 = gui.getColorCoding(tree.getGenome().getSecondary().isDominant());
        textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
        textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
        textLayout.newLine();
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.growth"), 12);
        gui.drawLine(tree.getGenome().getGrowthProvider().getDescription(), 90, tree, EnumTreeChromosome.GROWTH, false);
        gui.drawLine(((IAlleleGrowth)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GROWTH)).getProvider().getDescription(), 155, tree, EnumTreeChromosome.GROWTH, true);
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.native"), 12);
        textLayout.drawLine(Translator.translateToLocal("for.gui." + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 90, speciesDominance0);
        textLayout.drawLine(Translator.translateToLocal("for.gui." + tree.getGenome().getSecondary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 155, speciesDominance1);
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.tolerated"), 12);
        ArrayList<EnumPlantType> activeTolerated = new ArrayList<EnumPlantType>(tree.getGenome().getPlantTypes());
        List inactiveTolerated = Collections.emptyList();
        IAllele inactiveAllelePlant = tree.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT);
        if (inactiveAllelePlant instanceof AllelePlantType) {
            inactiveTolerated = new ArrayList<EnumPlantType>(((AllelePlantType)inactiveAllelePlant).getPlantTypes());
        }
        int max = Math.max(activeTolerated.size(), inactiveTolerated.size());
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                textLayout.newLine();
            }
            if (activeTolerated.size() > i) {
                gui.drawLine(Translator.translateToLocal("for.gui." + ((EnumPlantType)activeTolerated.get(i)).toString().toLowerCase(Locale.ENGLISH)), 90, tree, EnumTreeChromosome.PLANT, false);
            }
            if (inactiveTolerated.size() <= i) continue;
            gui.drawLine(Translator.translateToLocal("for.gui." + ((EnumPlantType)inactiveTolerated.get(i)).toString().toLowerCase(Locale.ENGLISH)), 155, tree, EnumTreeChromosome.PLANT, true);
        }
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.supports"), 12);
        ArrayList<IFruitFamily> families0 = new ArrayList<IFruitFamily>(tree.getGenome().getPrimary().getSuitableFruit());
        ArrayList<IFruitFamily> families1 = new ArrayList<IFruitFamily>(tree.getGenome().getSecondary().getSuitableFruit());
        max = Math.max(families0.size(), families1.size());
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                textLayout.newLine();
            }
            if (families0.size() > i) {
                textLayout.drawLine(((IFruitFamily)families0.get(i)).getName(), 90, speciesDominance0);
            }
            if (families1.size() <= i) continue;
            textLayout.drawLine(((IFruitFamily)families1.get(i)).getName(), 155, speciesDominance1);
        }
        textLayout.newLine();
        textLayout.newLine();
        int fruitDominance0 = gui.getColorCoding(tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).isDominant());
        int fruitDominance1 = gui.getColorCoding(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS).isDominant());
        textLayout.drawLine(Translator.translateToLocal("for.gui.fruits"), 12);
        String strike = "";
        IAllele fruit0 = tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS);
        if (!tree.canBearFruit() && fruit0 != AlleleFruit.fruitNone) {
            strike = TextFormatting.STRIKETHROUGH.toString();
        }
        textLayout.drawLine(strike + tree.getGenome().getFruitProvider().getDescription(), 90, fruitDominance0);
        strike = "";
        IAlleleFruit fruit1 = (IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS);
        if (!tree.getGenome().getSecondary().getSuitableFruit().contains(fruit1.getProvider().getFamily()) && fruit1 != AlleleFruit.fruitNone) {
            strike = TextFormatting.STRIKETHROUGH.toString();
        }
        textLayout.drawLine(strike + fruit1.getProvider().getDescription(), 155, fruitDominance1);
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.family"), 12);
        IFruitFamily primary = tree.getGenome().getFruitProvider().getFamily();
        IFruitFamily secondary = ((IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS)).getProvider().getFamily();
        if (primary != null) {
            textLayout.drawLine(primary.getName(), 90, fruitDominance0);
        }
        if (secondary != null) {
            textLayout.drawLine(secondary.getName(), 155, fruitDominance1);
        }
        textLayout.endPage();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage3(GuiAlyzer gui, ItemStack itemStack) {
        ITree tree = TreeManager.treeRoot.getMember(itemStack);
        if (tree == null) {
            return;
        }
        TextLayoutHelper textLayout = gui.getTextLayout();
        WidgetManager widgetManager = gui.getWidgetManager();
        textLayout.startPage(12, 90, 155);
        textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.produce") + ":", 12);
        textLayout.newLine();
        int x = 12;
        for (ItemStack stack : tree.getProducts().keySet()) {
            widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
            if ((x += 18) <= 148) continue;
            x = 12;
            textLayout.newLine();
        }
        textLayout.newLine();
        textLayout.newLine();
        textLayout.newLine();
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.specialty") + ":", 12);
        textLayout.newLine();
        x = 12;
        for (ItemStack stack : tree.getSpecialties().keySet()) {
            Proxies.common.getClientInstance().func_175599_af().func_175042_a(stack, gui.getGuiLeft() + x, gui.getGuiTop() + textLayout.getLineY());
            if ((x += 18) <= 148) continue;
            x = 12;
            textLayout.newLine();
        }
        textLayout.endPage();
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"treealyzer");
    }
}

