/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.models.BlankItemModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.TRSRBakedModel;
import java.util.Collections;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelButterflyItem
extends BlankItemModel {
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = new DefaultTextureGetter();
    @SideOnly(value=Side.CLIENT)
    private IRetexturableModel modelButterfly;

    @Override
    protected ItemOverrideList createOverrides() {
        return new ButterflyItemOverrideList();
    }

    private IBakedModel bakeModel(IButterfly butterfly) {
        ImmutableMap.Builder textures = ImmutableMap.builder();
        textures.put((Object)"butterfly", (Object)butterfly.getGenome().getSecondary().getItemTexture());
        this.modelButterfly = (IRetexturableModel)this.modelButterfly.retexture(textures.build());
        return new TRSRBakedModel(this.modelButterfly.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, this.textureGetter), -0.03125f, 0.0f, -0.03125f, butterfly.getSize() * 1.5f);
    }

    private class ButterflyItemOverrideList
    extends ItemOverrideList {
        public ButterflyItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IButterfly butterfly;
            if (ModelButterflyItem.this.modelButterfly == null) {
                try {
                    ModelButterflyItem.this.modelButterfly = (IRetexturableModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:item/butterflyGE"));
                }
                catch (Exception e) {
                    return null;
                }
                if (ModelButterflyItem.this.modelButterfly == null) {
                    return null;
                }
            }
            if ((butterfly = ButterflyManager.butterflyRoot.getMember(stack)) == null) {
                butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
            }
            return ModelButterflyItem.this.bakeModel(butterfly);
        }
    }
}

