/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerRaintank;
import forestry.factory.gui.GuiRaintank;
import forestry.factory.inventory.InventoryRaintank;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private int fillingTime;
    private ItemStack usedEmpty;

    public TileRaintank() {
        super("raintank");
        this.setInternalInventory(new InventoryRaintank(this));
        this.resourceTank = new FilteredTank(30000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        if (!this.updateOnInterval(20)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        BiomeGenBase biome = this.field_145850_b.getBiomeGenForCoordsBody(this.func_174877_v());
        errorLogic.setCondition(!biome.func_76738_d(), EnumErrorCode.NO_RAIN_BIOME);
        BlockPos posAbove = this.func_174877_v().func_177984_a();
        boolean hasSky = this.field_145850_b.func_175710_j(posAbove);
        errorLogic.setCondition(!hasSky, EnumErrorCode.NO_SKY_RAIN_TANK);
        errorLogic.setCondition(!this.field_145850_b.func_175727_C(posAbove), EnumErrorCode.NOT_RAINING);
        if (!errorLogic.hasErrors()) {
            this.resourceTank.fill(STACK_WATER, true);
        }
        if (!ItemStackUtil.isIdenticalItem(this.usedEmpty, this.func_70301_a(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = this.func_70301_a(0);
        }
        if (!this.isFilling()) {
            FluidHelper.FillStatus canFill = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, Fluids.WATER.getFluid(), false);
            if (canFill == FluidHelper.FillStatus.SUCCESS) {
                this.fillingTime = 12;
            }
        } else {
            FluidHelper.FillStatus filled;
            --this.fillingTime;
            if (this.fillingTime <= 0 && (filled = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, Fluids.WATER.getFluid())) == FluidHelper.FillStatus.SUCCESS) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiRaintank(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerRaintank(player.field_71071_by, this);
    }
}

