/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.CreativeTabForestry;
import forestry.core.circuits.SolderManager;
import forestry.core.config.Config;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemOverlay;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ItemElectronTube
extends ItemOverlay {
    public ItemElectronTube() {
        super(CreativeTabForestry.tabForestry, EnumElectronTube.VALUES);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        Multimap<ICircuitLayout, ICircuit> circuits = ItemElectronTube.getCircuits(itemstack);
        if (!circuits.isEmpty()) {
            if (Proxies.common.isShiftDown()) {
                for (ICircuitLayout circuitLayout : circuits.keys()) {
                    String circuitLayoutName = circuitLayout.getUsage();
                    list.add(TextFormatting.WHITE.toString() + TextFormatting.UNDERLINE + circuitLayoutName);
                    for (ICircuit circuit : circuits.get((Object)circuitLayout)) {
                        circuit.addTooltip(list);
                    }
                }
            } else {
                list.add(TextFormatting.ITALIC + "<" + Translator.translateToLocal("for.gui.tooltip.tmi") + ">");
            }
        } else {
            list.add("<" + Translator.translateToLocal("for.gui.noeffect") + ">");
        }
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (!Config.isDebug && this.overlays[i].isSecret()) continue;
            ItemStack itemStack = new ItemStack((Item)this, 1, i);
            if (!Config.isDebug && ItemElectronTube.getCircuits(itemStack).isEmpty()) continue;
            itemList.add(itemStack);
        }
    }

    private static Multimap<ICircuitLayout, ICircuit> getCircuits(ItemStack itemStack) {
        ArrayListMultimap circuits = ArrayListMultimap.create();
        Collection<ICircuitLayout> allLayouts = ChipsetManager.circuitRegistry.getRegisteredLayouts().values();
        for (ICircuitLayout circuitLayout : allLayouts) {
            ICircuit circuit = SolderManager.getCircuit(circuitLayout, itemStack);
            if (circuit == null) continue;
            circuits.put((Object)circuitLayout, (Object)circuit);
        }
        return circuits;
    }

    public ItemStack get(EnumElectronTube type, int amount) {
        return new ItemStack((Item)this, amount, type.ordinal());
    }
}

