/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    private static final int minHeight = 4;
    private static final int maxHeight = 80;
    private final int baseHeight;
    private final int heightVariation;
    protected int girth;
    protected int height;

    protected WorldGenTree(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree);
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int leafHeight = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, 0.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, 1.9f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight, 0), this.girth, 1.9f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
    }

    @Override
    protected void generateExtras(World world, Random rand, BlockPos startPos) {
        if (this.hasPods()) {
            WorldGenHelper.generatePods(this.tree, world, rand, startPos, this.height, 3, this.girth, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }

    @Override
    @Nullable
    public BlockPos getValidGrowthPos(World world, BlockPos pos) {
        return this.tree.canGrow(world, pos, this.girth, this.height);
    }

    @Override
    public final void preGenerate(World world, Random rand, BlockPos startPos) {
        super.preGenerate(world, rand, startPos);
        this.height = this.determineHeight(world, rand, this.baseHeight, this.heightVariation);
        this.girth = this.tree.getGirth(world, startPos);
    }

    protected int modifyByHeight(World world, int val, int min, int max) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int determined = Math.round((float)val * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return determined < min ? min : (determined > max ? max : determined);
    }

    private int determineHeight(World world, Random rand, int required, int variation) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int baseHeight = required + rand.nextInt(variation);
        int height = Math.round((float)baseHeight * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return height < 4 ? 4 : (height > 80 ? 80 : height);
    }
}

