/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.core.items.ItemFruit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class AlleleFruit
extends AlleleCategorized
implements IAlleleFruit {
    public static IAlleleFruit fruitNone;
    public static IAlleleFruit fruitApple;
    public static IAlleleFruit fruitCocoa;
    public static IAlleleFruit fruitChestnut;
    public static IAlleleFruit fruitCoconut;
    public static IAlleleFruit fruitWalnut;
    public static IAlleleFruit fruitCherry;
    public static IAlleleFruit fruitDates;
    public static IAlleleFruit fruitPapaya;
    public static IAlleleFruit fruitLemon;
    public static IAlleleFruit fruitPlum;
    public static IAlleleFruit fruitJujube;
    private static List<IAlleleFruit> fruitAlleles;
    private static List<IAlleleFruit> fruitAllelesWithModels;
    @Nonnull
    private final IFruitProvider provider;

    public static void createAlleles() {
        fruitNone = new AlleleFruit("none", new FruitProviderNone("for.fruits.none", null));
        fruitApple = new AlleleFruit("apple", new FruitProviderRandom("for.fruits.apple", EnumFruitFamily.POMES, new ItemStack(Items.field_151034_e), 1.0f).setColour(new Color(0xFF2E2E)).setOverlay("pomes"));
        List<IAlleleFruit> fruitAlleles = Arrays.asList(fruitNone, fruitApple, fruitCocoa = new AlleleFruit("cocoa", new FruitProviderPod("for.fruits.cocoa", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.COCOA, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()))), fruitChestnut = new AlleleFruit("chestnut", new FruitProviderRipening("for.fruits.chestnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.CHESTNUT.getStack(), 1.0f).setRipeningPeriod(6).setColours(new Color(8336189), new Color(12898890)).setOverlay("nuts"), true), fruitWalnut = new AlleleFruit("walnut", new FruitProviderRipening("for.fruits.walnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.WALNUT.getStack(), 1.0f).setRipeningPeriod(8).setColours(new Color(16491080), new Color(12898890)).setOverlay("nuts"), true), fruitCherry = new AlleleFruit("cherry", new FruitProviderRipening("for.fruits.cherry", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.CHERRY.getStack(), 1.0f).setColours(new Color(0xFF2E2E), new Color(12898890)).setOverlay("berries"), true), fruitDates = new AlleleFruit("dates", new FruitProviderPod("for.fruits.dates", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.DATES, ItemFruit.EnumFruit.DATES.getStack(4))), fruitPapaya = new AlleleFruit("papaya", new FruitProviderPod("for.fruits.papaya", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.PAPAYA, ItemFruit.EnumFruit.PAPAYA.getStack())), fruitLemon = new AlleleFruit("lemon", new FruitProviderRipening("for.fruits.lemon", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.LEMON.getStack(), 1.0f).setColours(new Color(0xEEEE00), new Color(0x99FF00)).setOverlay("citrus"), true), fruitPlum = new AlleleFruit("plum", new FruitProviderRipening("for.fruits.plum", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.PLUM.getStack(), 1.0f).setColours(new Color(0x663446), new Color(15662874)).setOverlay("plums"), true));
        for (IAlleleFruit fruitAllele : fruitAlleles) {
            AlleleManager.alleleRegistry.registerAllele(fruitAllele, EnumTreeChromosome.FRUITS);
        }
    }

    public static List<IAlleleFruit> getFruitAlleles() {
        if (fruitAlleles == null) {
            fruitAlleles = new ArrayList<IAlleleFruit>();
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleFruit)) continue;
                IAlleleFruit alleleFruit = (IAlleleFruit)allele;
                fruitAlleles.add(alleleFruit);
            }
        }
        return fruitAlleles;
    }

    public static List<IAlleleFruit> getFruitAllelesWithModels() {
        if (fruitAllelesWithModels == null) {
            fruitAllelesWithModels = new ArrayList<IAlleleFruit>();
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                IAlleleFruit alleleFruit;
                if (!(allele instanceof IAlleleFruit) || (alleleFruit = (IAlleleFruit)allele).getModelName() == null) continue;
                fruitAllelesWithModels.add(alleleFruit);
            }
        }
        return fruitAllelesWithModels;
    }

    public AlleleFruit(@Nonnull String name, @Nonnull IFruitProvider provider) {
        this(name, provider, false);
    }

    public AlleleFruit(@Nonnull String name, @Nonnull IFruitProvider provider, boolean isDominant) {
        super("Forestry", "fruit", name, isDominant);
        this.provider = provider;
    }

    @Override
    @Nonnull
    public IFruitProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.getProvider().getDescription();
    }

    @Override
    @Nullable
    public String getModelName() {
        return this.getProvider().getModelName();
    }

    @Override
    @Nonnull
    public String getModID() {
        return this.getProvider().getModID();
    }

    @Override
    public int compareTo(@Nonnull IAlleleFruit o) {
        return 0;
    }
}

